/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class BugReportQueue {
    public static final BugReportHandler FALLBACK_BUGREPORT_HANDLER = (e, index) -> {
        e.printStackTrace();
        return SuppressionMode.NONE;
    };
    private static final BugReportQueue INSTANCE = new BugReportQueue();
    private final LinkedList<ReportedException> reportsToDisplay = new LinkedList();
    private boolean suppressAllMessages;
    private final ArrayList<ReportedException> suppressFor = new ArrayList();
    private Thread displayThread;
    private BugReportHandler bugReportHandler = FALLBACK_BUGREPORT_HANDLER;
    private final CopyOnWriteArrayList<Predicate<ReportedException>> handlers = new CopyOnWriteArrayList();
    private int displayedErrors;
    private boolean inReportDialog;

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void submit(ReportedException report) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        Logging.logWithStackTrace(Logging.LEVEL_ERROR, "Handled by bug report queue", report.getCause());
                        if (this.suppressAllMessages) break block7;
                        if (!this.suppressFor.stream().anyMatch(report::isSame)) break block8;
                    }
                    Logging.info("User requested to skip error " + String.valueOf(report));
                    return;
                }
                if (this.reportsToDisplay.size() > 100) break block9;
                if (this.reportsToDisplay.stream().filter(report::isSame).count() < 10L) break block10;
            }
            Logging.warn("Too many errors. Dropping " + String.valueOf(report));
            return;
        }
        this.reportsToDisplay.add(report);
        if (this.displayThread == null) {
            this.displayThread = new Thread((Runnable)new BugReportDisplayRunnable(), "bug-report-display");
            this.displayThread.start();
        }
        this.notifyAll();
    }

    private synchronized void handleDialogResult(ReportedException e, SuppressionMode suppress) {
        if (suppress == SuppressionMode.ALL) {
            this.suppressAllMessages = true;
            this.reportsToDisplay.clear();
        } else if (suppress == SuppressionMode.SAME) {
            this.suppressFor.add(e);
            this.reportsToDisplay.removeIf(e::isSame);
        }
        ++this.displayedErrors;
        this.inReportDialog = false;
    }

    private synchronized ReportedException getNext() throws InterruptedException {
        while (this.reportsToDisplay.isEmpty()) {
            this.wait();
        }
        this.inReportDialog = true;
        return this.reportsToDisplay.removeFirst();
    }

    private SuppressionMode displayFor(ReportedException e) {
        if (this.handlers.stream().anyMatch(p -> p.test(e))) {
            Logging.trace("Intercepted by handler.");
            return SuppressionMode.NONE;
        }
        return this.bugReportHandler.handle(e, this.getDisplayedErrors());
    }

    private synchronized int getDisplayedErrors() {
        return this.displayedErrors;
    }

    public synchronized boolean exceptionHandlingInProgress() {
        return !this.reportsToDisplay.isEmpty() || this.inReportDialog;
    }

    public void setBugReportHandler(BugReportHandler bugReportHandler) {
        this.bugReportHandler = Objects.requireNonNull(bugReportHandler, "bugReportHandler");
    }

    public void addBugReportHandler(Predicate<ReportedException> handler) {
        this.handlers.add(handler);
    }

    public static BugReportQueue getInstance() {
        return INSTANCE;
    }

    @FunctionalInterface
    public static interface BugReportHandler {
        public SuppressionMode handle(ReportedException var1, int var2);
    }

    private final class BugReportDisplayRunnable
    implements Runnable {
        private volatile boolean running = true;

        private BugReportDisplayRunnable() {
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    ReportedException e = BugReportQueue.this.getNext();
                    BugReportQueue.this.handleDialogResult(e, BugReportQueue.this.displayFor(e));
                }
            }
            catch (InterruptedException e) {
                BugReportQueue.this.displayFor(BugReport.intercept(e));
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum SuppressionMode {
        NONE,
        SAME,
        ALL;

    }
}

