/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.projection.datum.NTV2Proj4DirGridShiftFileSource;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.PlatformVisitor;
import org.openstreetmap.josm.tools.Utils;

public interface PlatformHook {
    public static final PlatformVisitor<PlatformHook> CONSTRUCT_FROM_PLATFORM = new PlatformVisitor<PlatformHook>(){

        @Override
        public PlatformHook visitUnixoid() {
            return new PlatformHookUnixoid();
        }

        @Override
        public PlatformHook visitWindows() {
            return new PlatformHookWindows();
        }

        @Override
        public PlatformHook visitOsx() {
            return new PlatformHookOsx();
        }
    };

    public Platform getPlatform();

    default public void preStartupHook() {
    }

    default public void afterPrefStartupHook() {
    }

    default public void startupHook(JavaExpirationCallback javaCallback, SanityCheckCallback sanityCheckCallback) {
        this.startupSanityChecks(sanityCheckCallback);
    }

    public void openUrl(String var1) throws IOException;

    public void initSystemShortcuts();

    public String getDefaultStyle();

    default public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    default public boolean rename(File from, File to) {
        return from.renameTo(to);
    }

    public String getOSDescription();

    default public String getOSBuildNumber() {
        return "";
    }

    default public X509Certificate getX509Certificate(CertificateAmendment.NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return null;
    }

    default public String exec(String ... command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
            String string = Utils.strip(input.readLine());
            return string;
        }
    }

    public File getDefaultCacheDirectory();

    public File getDefaultPrefDirectory();

    public File getDefaultUserDataDirectory();

    default public List<File> getDefaultProj4NadshiftDirectories() {
        return this.getPlatform().accept(NTV2Proj4DirGridShiftFileSource.getInstance());
    }

    default public boolean isOpenJDK() {
        String javaHome = Utils.getSystemProperty("java.home");
        return javaHome != null && javaHome.contains("openjdk");
    }

    default public boolean isHtmlSupportedInMenuTooltips() {
        return true;
    }

    default public int getMenuShortcutKeyMaskEx() {
        if (!GraphicsEnvironment.isHeadless()) {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        }
        return 128;
    }

    default public void warnSoonToBeUnsupportedJava(JavaExpirationCallback callback) {
        if (Utils.getJavaVersion() < 17 && !Utils.isRunningWebStart()) {
            String latestVersion = Utils.getJavaLatestVersion();
            String currentVersion = Utils.getSystemProperty("java.version");
            if (latestVersion == null || !latestVersion.equalsIgnoreCase(currentVersion)) {
                callback.askUpdateJava(latestVersion != null ? latestVersion : "latest", Config.getPref().get("java.update.url", this.getJavaUrl()), null, Utils.getJavaVersion() < 17);
            }
        }
    }

    default public String getJavaUrl() {
        StringBuilder defaultDownloadUrl = new StringBuilder("https://www.azul.com/downloads/?version=java-21-lts");
        if (PlatformManager.isPlatformWindows()) {
            defaultDownloadUrl.append("&os=windows");
        } else if (PlatformManager.isPlatformOsx()) {
            defaultDownloadUrl.append("&os=macos");
        }
        String osArch = System.getProperty("os.arch");
        if (osArch != null) {
            if ("x86_64".equals(osArch) || "amd64".equals(osArch) || "AMD64".equalsIgnoreCase(System.getenv("PROCESSOR_ARCHITEW6432"))) {
                defaultDownloadUrl.append("&architecture=x86-64-bit").append("&package=jdk-fx");
            } else if ("aarch64".equals(osArch)) {
                defaultDownloadUrl.append("&architecture=arm-64-bit").append("&package=jdk-fx");
            } else if ("x86".equals(osArch)) {
                defaultDownloadUrl.append("&architecture=x86-32-bit").append("&package=jdk");
            }
        }
        defaultDownloadUrl.append("#zulu");
        return defaultDownloadUrl.toString();
    }

    default public void startupSanityChecks(SanityCheckCallback sanityCheckCallback) {
        String arch = System.getProperty("os.arch");
        ArrayList<String> messages = new ArrayList<String>();
        String jvmArch = System.getProperty("sun.arch.data.model");
        boolean canContinue = true;
        if (Utils.getJavaVersion() < 11) {
            canContinue = false;
            messages.add(I18n.tr("You must update Java to Java {0} or later in order to run this version of JOSM", 17));
            Config.getPref().put("askUpdateWebStart", null);
            Config.getPref().put("askUpdateJava" + Utils.getJavaLatestVersion(), null);
            Config.getPref().put("askUpdateJavalatest", null);
        }
        if (!"x86".equals(arch) && "32".equals(jvmArch)) {
            messages.add(I18n.tr("Please use a 64 bit version of Java -- this will avoid out of memory errors", new Object[0]));
        }
        String[] expectedJvmArguments = new String[]{"--add-exports=java.base/sun.security.action=ALL-UNNAMED", "--add-exports=java.desktop/com.sun.imageio.plugins.jpeg=ALL-UNNAMED", "--add-exports=java.desktop/com.sun.imageio.spi=ALL-UNNAMED"};
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuilder missingArguments = new StringBuilder();
        for (String arg : expectedJvmArguments) {
            if (!vmArguments.stream().noneMatch(s -> s.contains(arg))) continue;
            if (missingArguments.length() > 0) {
                missingArguments.append("<br>");
            }
            missingArguments.append(arg);
        }
        if (missingArguments.length() > 0) {
            String args = missingArguments.toString();
            messages.add(I18n.tr("Missing JVM Arguments:<br>{0}<br>These arguments should be added in the command line or start script before the -jar parameter.", args));
        }
        if (!messages.isEmpty()) {
            if (canContinue) {
                sanityCheckCallback.sanityCheckFailed(I18n.tr("JOSM may work improperly", new Object[0]), true, messages.toArray(new String[0]));
            } else {
                sanityCheckCallback.sanityCheckFailed(I18n.tr("JOSM will be unable to work properly and will exit", new Object[0]), false, messages.toArray(new String[0]));
            }
        }
    }

    default public void setNativeOsCallback(NativeOsCallback callback) {
    }

    default public File resolveFileLink(File file) {
        return file;
    }

    default public Collection<String> getPossiblePreferenceDirs() {
        return Collections.emptyList();
    }

    @FunctionalInterface
    public static interface SanityCheckCallback {
        public void sanityCheckFailed(String var1, boolean var2, String ... var3);
    }

    @FunctionalInterface
    public static interface JavaExpirationCallback {
        public void askUpdateJava(String var1, String var2, String var3, boolean var4);
    }

    public static interface NativeOsCallback {
        public void openFiles(List<File> var1);

        public boolean handleQuitRequest();

        public void handleAbout();

        public void handlePreferences();
    }
}

