/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.DividedScale;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaIconElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.DefaultStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.LineElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.RepeatImageElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Pair;

public class ElemStyles
implements PreferenceChangedListener {
    private final List<StyleSource> styleSources = Collections.synchronizedList(new ArrayList());
    private boolean drawMultipolygon;
    private short cacheIdx = 1;
    private boolean defaultNodes;
    private boolean defaultLines;
    private short defaultNodesIdx;
    private short defaultLinesIdx;
    private final Map<String, String> preferenceCache = Collections.synchronizedMap(new HashMap());
    private volatile Color backgroundColorCache;

    public ElemStyles() {
        Config.getPref().addPreferenceChangeListener(this);
    }

    public ElemStyles(Collection<StyleSource> sources) {
        this.styleSources.addAll(sources);
    }

    public void clearCached() {
        GuiHelper.runInEDT(() -> {
            this.cacheIdx = (short)(this.cacheIdx + 1);
            this.preferenceCache.clear();
            this.backgroundColorCache = null;
            MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).forEach(dl -> dl.data.clearMappaintCache());
        });
    }

    public List<StyleSource> getStyleSources() {
        return Collections.unmodifiableList(this.styleSources);
    }

    public Color getBackgroundColor() {
        if (this.backgroundColorCache != null) {
            return this.backgroundColorCache;
        }
        for (StyleSource s : this.styleSources) {
            Color backgroundColorOverride;
            if (!s.active || (backgroundColorOverride = s.getBackgroundColorOverride()) == null) continue;
            this.backgroundColorCache = backgroundColorOverride;
        }
        return Optional.ofNullable(this.backgroundColorCache).orElseGet(PaintColors.BACKGROUND::get);
    }

    public StyleElementList get(IPrimitive osm, double scale, NavigatableComponent nc) {
        return (StyleElementList)this.getStyleCacheWithRange((IPrimitive)osm, (double)scale, (NavigatableComponent)nc).a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<StyleElementList, Range> getStyleCacheWithRange(IPrimitive osm, double scale, NavigatableComponent nc) {
        Object object = osm.getStyleCacheSyncObject();
        synchronized (object) {
            if (!osm.isCachedStyleUpToDate(this) || scale <= 0.0) {
                osm.setCachedStyle(this, StyleCache.EMPTY_STYLECACHE);
            } else {
                Pair<StyleElementList, Range> lst = osm.getCachedStyle(this).getWithRange(scale, osm.isSelected());
                if (lst.a != null) {
                    return lst;
                }
            }
            Pair<StyleElementList, Range> p = this.getImpl(osm, scale, nc);
            if (osm instanceof INode && this.isDefaultNodes()) {
                if (((StyleElementList)p.a).isEmpty()) {
                    p.a = TextLabel.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osm) != null ? DefaultStyles.DEFAULT_NODE_STYLELIST_TEXT : DefaultStyles.DEFAULT_NODE_STYLELIST;
                } else {
                    boolean hasNonModifier = false;
                    boolean hasText = false;
                    for (StyleElement s : (StyleElementList)p.a) {
                        if (s instanceof BoxTextElement) {
                            hasText = true;
                            continue;
                        }
                        if (s.isModifier) continue;
                        hasNonModifier = true;
                    }
                    if (!hasNonModifier) {
                        p.a = new StyleElementList((StyleElementList)p.a, (StyleElement)DefaultStyles.SIMPLE_NODE_ELEMSTYLE);
                        if (!hasText && TextLabel.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osm) != null) {
                            p.a = new StyleElementList((StyleElementList)p.a, (StyleElement)DefaultStyles.SIMPLE_NODE_TEXT_ELEMSTYLE);
                        }
                    }
                }
            } else if (osm instanceof IWay && this.isDefaultLines()) {
                boolean hasProperLineStyle = false;
                for (StyleElement s : (StyleElementList)p.a) {
                    if (!s.isProperLineStyle()) continue;
                    hasProperLineStyle = true;
                    break;
                }
                if (!hasProperLineStyle) {
                    LineElement line = LineElement.UNTAGGED_WAY;
                    for (StyleElement element : (StyleElementList)p.a) {
                        if (!(element instanceof AreaElement)) continue;
                        line = LineElement.createSimpleLineStyle(((AreaElement)element).color, true);
                        break;
                    }
                    p.a = new StyleElementList((StyleElementList)p.a, (StyleElement)line);
                }
            }
            StyleCache style = osm.getCachedStyle(this) != null ? osm.getCachedStyle(this) : StyleCache.EMPTY_STYLECACHE;
            try {
                osm.setCachedStyle(this, style.put((StyleElementList)p.a, (Range)p.b, osm.isSelected()));
            }
            catch (DividedScale.RangeViolatedError e) {
                throw new AssertionError("Range violated: " + e.getMessage() + " (object: " + String.valueOf(osm.getPrimitiveId()) + ", current style: " + String.valueOf(osm.getCachedStyle(this)) + ", scale: " + scale + ", new stylelist: " + String.valueOf(p.a) + ", new range: " + String.valueOf(p.b) + ")", e);
            }
            osm.declareCachedStyleUpToDate(this);
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<StyleElementList, Range> getImpl(IPrimitive osm, double scale, NavigatableComponent nc) {
        if (osm instanceof INode) {
            return this.generateStyles(osm, scale, false);
        }
        if (osm instanceof IWay) {
            Multipolygon multipolygon;
            Pair<StyleElementList, Range> p = this.generateStyles(osm, scale, false);
            boolean isOuterWayOfSomeMP = false;
            Color wayColor = null;
            block6: for (IPrimitive iPrimitive : osm.getReferrers()) {
                Pair<StyleElementList, Range> mpElemStyles;
                IRelation r = (IRelation)iPrimitive;
                if (!this.drawMultipolygon || !r.isMultipolygon() || !r.isUsable() || !(r instanceof Relation) || !(multipolygon = MultipolygonCache.getInstance().get((Relation)r)).getOuterWays().contains(osm)) continue;
                boolean hasIndependentLineStyle = false;
                if (!isOuterWayOfSomeMP) {
                    ArrayList<StyleElement> tmp = new ArrayList<StyleElement>(((StyleElementList)p.a).size());
                    for (StyleElement s : (StyleElementList)p.a) {
                        if (s instanceof AreaElement) {
                            wayColor = ((AreaElement)s).color;
                            continue;
                        }
                        tmp.add(s);
                        if (!s.isProperLineStyle()) continue;
                        hasIndependentLineStyle = true;
                    }
                    p.a = new StyleElementList(tmp);
                    isOuterWayOfSomeMP = true;
                }
                if (hasIndependentLineStyle) continue;
                IRelation iRelation = r;
                synchronized (iRelation) {
                    mpElemStyles = this.getStyleCacheWithRange(r, scale, nc);
                }
                StyleElement mpLine = null;
                for (StyleElement s : (StyleElementList)mpElemStyles.a) {
                    if (!s.isProperLineStyle()) continue;
                    mpLine = s;
                    break;
                }
                p.b = Range.cut((Range)p.b, (Range)mpElemStyles.b);
                if (mpLine != null) {
                    p.a = new StyleElementList((StyleElementList)p.a, mpLine);
                    break;
                }
                if (wayColor != null || !this.isDefaultLines()) continue;
                for (StyleElement element : (StyleElementList)mpElemStyles.a) {
                    if (!(element instanceof AreaElement)) continue;
                    wayColor = ((AreaElement)element).color;
                    continue block6;
                }
            }
            if (isOuterWayOfSomeMP) {
                if (this.isDefaultLines()) {
                    boolean hasLineStyle = false;
                    for (StyleElement s : (StyleElementList)p.a) {
                        if (!s.isProperLineStyle()) continue;
                        hasLineStyle = true;
                        break;
                    }
                    if (!hasLineStyle) {
                        p.a = new StyleElementList((StyleElementList)p.a, (StyleElement)LineElement.createSimpleLineStyle(wayColor, true));
                    }
                }
                return p;
            }
            if (!this.isDefaultLines()) {
                return p;
            }
            for (IPrimitive iPrimitive : osm.getReferrers()) {
                IRelation ref = (IRelation)iPrimitive;
                if (!this.drawMultipolygon || !ref.isMultipolygon() || !ref.isUsable() || !(ref instanceof Relation) || !(multipolygon = MultipolygonCache.getInstance().get((Relation)ref)).getInnerWays().contains(osm)) continue;
                p = this.generateStyles(osm, scale, false);
                boolean hasIndependentElemStyle = false;
                for (StyleElement s : (StyleElementList)p.a) {
                    if (!s.isProperLineStyle() && !(s instanceof AreaElement)) continue;
                    hasIndependentElemStyle = true;
                    break;
                }
                if (!hasIndependentElemStyle && !multipolygon.getOuterWays().isEmpty()) {
                    StyleElementList mpElemStyles;
                    Color mpColor = null;
                    Iterator<StyleElement> iterator = ref;
                    synchronized (iterator) {
                        mpElemStyles = this.get(ref, scale, nc);
                    }
                    for (StyleElement mpS : mpElemStyles) {
                        if (!(mpS instanceof AreaElement)) continue;
                        mpColor = ((AreaElement)mpS).color;
                        break;
                    }
                    p.a = new StyleElementList((StyleElementList)p.a, (StyleElement)LineElement.createSimpleLineStyle(mpColor, true));
                }
                return p;
            }
            return p;
        }
        if (osm instanceof IRelation) {
            return this.generateStyles(osm, scale, true);
        }
        return null;
    }

    public Pair<StyleElementList, Range> generateStyles(IPrimitive osm, double scale, boolean pretendWayIsClosed) {
        ArrayList<StyleElement> sl = new ArrayList<StyleElement>();
        MultiCascade mc = new MultiCascade();
        Environment env = new Environment(osm, mc, null, null);
        for (StyleSource styleSource : this.styleSources) {
            if (!styleSource.active) continue;
            styleSource.apply(mc, osm, scale, pretendWayIsClosed);
        }
        for (Map.Entry entry : mc.getLayers()) {
            AreaElement areaStyle;
            if ("*".equals(entry.getKey())) continue;
            env.layer = (String)entry.getKey();
            if (osm instanceof IWay) {
                areaStyle = AreaElement.create(env);
                ElemStyles.addIfNotNull(sl, areaStyle);
                ElemStyles.addIfNotNull(sl, RepeatImageElement.create(env));
                ElemStyles.addIfNotNull(sl, LineElement.createLine(env));
                ElemStyles.addIfNotNull(sl, LineElement.createLeftCasing(env));
                ElemStyles.addIfNotNull(sl, LineElement.createRightCasing(env));
                ElemStyles.addIfNotNull(sl, LineElement.createCasing(env));
                ElemStyles.addIfNotNull(sl, AreaIconElement.create(env));
                ElemStyles.addIfNotNull(sl, TextElement.create(env));
                if (areaStyle == null) continue;
                ElemStyles.addIfNotNull(sl, TextElement.createForContent(env));
                continue;
            }
            if (osm instanceof INode) {
                NodeElement nodeStyle = NodeElement.create(env);
                if (nodeStyle != null) {
                    sl.add(nodeStyle);
                    ElemStyles.addIfNotNull(sl, BoxTextElement.create(env, nodeStyle.getBoxProvider()));
                    continue;
                }
                ElemStyles.addIfNotNull(sl, BoxTextElement.create(env, DefaultStyles.SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER));
                continue;
            }
            if (!(osm instanceof IRelation)) continue;
            if (((IRelation)osm).isMultipolygon()) {
                areaStyle = AreaElement.create(env);
                ElemStyles.addIfNotNull(sl, areaStyle);
                ElemStyles.addIfNotNull(sl, RepeatImageElement.create(env));
                ElemStyles.addIfNotNull(sl, LineElement.createLine(env));
                ElemStyles.addIfNotNull(sl, LineElement.createCasing(env));
                ElemStyles.addIfNotNull(sl, AreaIconElement.create(env));
                ElemStyles.addIfNotNull(sl, TextElement.create(env));
                if (areaStyle == null) continue;
                ElemStyles.addIfNotNull(sl, TextElement.createForContent(env));
                continue;
            }
            if (!osm.hasTag("type", "restriction")) continue;
            ElemStyles.addIfNotNull(sl, NodeElement.create(env));
        }
        return new Pair<StyleElementList, Range>(new StyleElementList(sl), mc.range);
    }

    private static <T> void addIfNotNull(List<T> list, T obj) {
        if (obj != null) {
            list.add(obj);
        }
    }

    private boolean isDefaultNodes() {
        if (this.defaultNodesIdx == this.cacheIdx) {
            return this.defaultNodes;
        }
        this.defaultNodes = this.fromCanvas("default-points", Boolean.TRUE, Boolean.class);
        this.defaultNodesIdx = this.cacheIdx;
        return this.defaultNodes;
    }

    private boolean isDefaultLines() {
        if (this.defaultLinesIdx == this.cacheIdx) {
            return this.defaultLines;
        }
        this.defaultLines = this.fromCanvas("default-lines", Boolean.TRUE, Boolean.class);
        this.defaultLinesIdx = this.cacheIdx;
        return this.defaultLines;
    }

    private <T> T fromCanvas(String key, T def, Class<T> c) {
        MultiCascade mc = new MultiCascade();
        Relation r = new Relation();
        r.put("#canvas", "query");
        for (StyleSource s : this.styleSources) {
            if (!s.active) continue;
            s.apply(mc, r, 1.0, false);
        }
        return mc.getCascade("default").get(key, def, c);
    }

    public boolean isDrawMultipolygon() {
        return this.drawMultipolygon;
    }

    public void setDrawMultipolygon(boolean drawMultipolygon) {
        this.drawMultipolygon = drawMultipolygon;
    }

    void clear() {
        this.styleSources.clear();
    }

    void add(StyleSource style) {
        this.styleSources.add(Objects.requireNonNull(style));
    }

    boolean remove(StyleSource style) {
        return this.styleSources.remove(Objects.requireNonNull(style));
    }

    void setStyleSources(Collection<StyleSource> sources) {
        this.styleSources.clear();
        sources.forEach(this::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AreaElement getAreaElemStyle(IPrimitive p, boolean pretendWayIsClosed) {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            if (MapPaintStyles.getStyles() == null) {
                AreaElement areaElement = null;
                return areaElement;
            }
            for (StyleElement s : (StyleElementList)MapPaintStyles.getStyles().generateStyles((IPrimitive)p, (double)1.0, (boolean)pretendWayIsClosed).a) {
                if (!(s instanceof AreaElement)) continue;
                AreaElement areaElement = (AreaElement)s;
                return areaElement;
            }
            Iterator<StyleElement> iterator = null;
            return iterator;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    public static boolean hasAreaElemStyle(IPrimitive p, boolean pretendWayIsClosed) {
        return ElemStyles.getAreaElemStyle(p, pretendWayIsClosed) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOnlyAreaElements(IPrimitive p) {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            if (MapPaintStyles.getStyles() == null) {
                boolean bl = false;
                return bl;
            }
            StyleElementList styles = (StyleElementList)MapPaintStyles.getStyles().generateStyles((IPrimitive)p, (double)1.0, (boolean)false).a;
            boolean hasAreaElement = false;
            for (StyleElement s : styles) {
                if (s instanceof TextElement) continue;
                if (!(s instanceof AreaElement)) {
                    boolean bl = false;
                    return bl;
                }
                hasAreaElement = true;
            }
            boolean bl = hasAreaElement;
            return bl;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    public String getPreferenceCached(StyleSource source, String key, String def) {
        String res;
        if (this.preferenceCache.containsKey(key)) {
            res = this.preferenceCache.get(key);
        } else {
            Color realDef = Cascade.convertTo(def, Color.class);
            if (realDef != null) {
                String prefName = source != null ? source.getFileNamePart() : "unknown";
                NamedColorProperty property = new NamedColorProperty("mappaint", prefName, key, realDef);
                res = ColorHelper.color2html(property.get());
            } else {
                res = Config.getPref().get(key, null);
            }
            this.preferenceCache.put(key, res);
        }
        return res != null ? res : def;
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (this.preferenceCache.containsKey(e.getKey())) {
            this.clearCached();
        }
    }
}

