/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.gpx.GpxTimeOffset;
import org.openstreetmap.josm.data.gpx.GpxTimezone;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class AdjustTimezoneAndOffsetDialog
extends ExtendedDialog {
    private AdjustListener listener;

    public AdjustTimezoneAndOffsetDialog(Component parent, GpxTimezone tz, GpxTimeOffset offset, int dayOffset) {
        super(parent, I18n.tr("Adjust timezone and offset", new Object[0]), I18n.tr("Close", new Object[0]));
        this.setContent(this.buildContent(tz, offset, dayOffset));
        this.setButtonIcons("ok");
    }

    private Component buildContent(GpxTimezone a, GpxTimeOffset b, int dayOffset) {
        JLabel lblMatches = new JLabel();
        JLabel lblTimezone = new JLabel();
        JSlider sldTimezone = new JSlider(-24, 24, 0);
        sldTimezone.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = -12; i <= 12; i += 6) {
            ((Dictionary)labelTable).put(i * 2, new JLabel(new GpxTimezone(i).formatTimezone()));
        }
        sldTimezone.setLabelTable(labelTable);
        JLabel lblMinutes = new JLabel();
        JSlider sldMinutes = new JSlider(-15, 15, 0);
        sldMinutes.setPaintLabels(true);
        sldMinutes.setMajorTickSpacing(5);
        JLabel lblSeconds = new JLabel();
        JSlider sldSeconds = new JSlider(-600, 600, 0);
        sldSeconds.setPaintLabels(true);
        labelTable = new Hashtable();
        for (int i = -60; i <= 60; i += 30) {
            ((Dictionary)labelTable).put(i * 10, new JLabel(GpxTimeOffset.seconds(i).formatOffset()));
        }
        sldSeconds.setLabelTable(labelTable);
        sldSeconds.setMajorTickSpacing(300);
        JPanel p = new JPanel(new GridBagLayout());
        p.setPreferredSize(new Dimension(400, 230));
        p.add((Component)lblMatches, GBC.eol().fill());
        p.add((Component)lblTimezone, GBC.eol().fill());
        p.add((Component)sldTimezone, GBC.eol().fill().insets(0, 0, 0, 10));
        p.add((Component)lblMinutes, GBC.eol().fill());
        p.add((Component)sldMinutes, GBC.eol().fill().insets(0, 0, 0, 10));
        p.add((Component)lblSeconds, GBC.eol().fill());
        p.add((Component)sldSeconds, GBC.eol().fill());
        try {
            sldTimezone.setValue((int)(a.getHours() * 2.0));
            sldMinutes.setValue((int)(b.getSeconds() / 60L));
            long deciSeconds = b.getMilliseconds() / 100L;
            sldSeconds.setValue((int)(deciSeconds % 600L));
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException ex) {
            Logging.warn(ex);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("An error occurred while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos.", new Object[0]), I18n.tr("Matching photos to track failed", new Object[0]), 2);
        }
        ChangeListener sliderListener = x -> {
            GpxTimezone timezone = new GpxTimezone((double)sldTimezone.getValue() / 2.0);
            int minutes = sldMinutes.getValue();
            int seconds = sldSeconds.getValue();
            lblTimezone.setText(I18n.tr("Timezone: {0}", timezone.formatTimezone()));
            lblMinutes.setText(I18n.tr("Minutes: {0}", minutes));
            lblSeconds.setText(I18n.tr("Seconds: {0}", GpxTimeOffset.milliseconds(100L * (long)seconds).formatOffset()));
            StringBuilder sb = new StringBuilder("<html>");
            if (this.listener != null) {
                sb.append(this.listener.valuesChanged(timezone, minutes, seconds)).append("<br>");
            }
            lblMatches.setText(sb.append(I18n.trn("(Time difference of {0} day)", "Time difference of {0} days", Math.abs(dayOffset), Math.abs(dayOffset))).append("</html>").toString());
        };
        sliderListener.stateChanged(null);
        sldTimezone.addChangeListener(sliderListener);
        sldMinutes.addChangeListener(sliderListener);
        sldSeconds.addChangeListener(sliderListener);
        return p;
    }

    public final AdjustTimezoneAndOffsetDialog adjustListener(AdjustListener listener) {
        this.listener = listener;
        return this;
    }

    @FunctionalInterface
    public static interface AdjustListener {
        public String valuesChanged(GpxTimezone var1, int var2, int var3);
    }
}

