/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class CrossingWays
extends Test {
    static final String BARRIER = "barrier";
    static final String HIGHWAY = "highway";
    static final String RAILWAY = "railway";
    static final String WATERWAY = "waterway";
    static final String LANDUSE = "landuse";
    private final Map<Point2D, List<WaySegment>> cellSegments = new HashMap<Point2D, List<WaySegment>>(1000);
    private final Map<List<Way>, List<WaySegment>> seenWays = new HashMap<List<Way>, List<WaySegment>>(50);
    private final Set<Way> waysToTest = new HashSet<Way>();
    protected final int code;

    protected CrossingWays(String title, int code) {
        super(title, I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
        this.code = code;
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.cellSegments.clear();
        this.seenWays.clear();
    }

    @Override
    public void endTest() {
        this.runTest();
        this.cellSegments.clear();
        this.seenWays.clear();
        if (this.partialSelection) {
            this.removeIrrelevantErrors(this.waysToTest);
        }
        this.waysToTest.clear();
        super.endTest();
    }

    protected void runTest() {
        Collection<Way> selection = this instanceof SelfCrossing || !this.partialSelection ? this.waysToTest : this.addNearbyObjects();
        for (Way w : selection) {
            this.testWay(w);
        }
    }

    private Collection<Way> addNearbyObjects() {
        HashSet<Way> selection = new HashSet<Way>();
        DataSet ds = OsmDataManager.getInstance().getActiveDataSet();
        if (ds != null) {
            for (Way wt : this.waysToTest) {
                selection.addAll(ds.searchWays(wt.getBBox()).stream().filter(w -> !w.isDeleted() && this.isPrimitiveUsable((OsmPrimitive)w)).collect(Collectors.toList()));
                if (!(this instanceof Boundaries)) continue;
                List relations = ds.searchRelations(wt.getBBox()).stream().filter(this::isPrimitiveUsable).collect(Collectors.toList());
                for (Relation r : relations) {
                    for (Way w2 : r.getMemberPrimitives(Way.class)) {
                        if (w2.isIncomplete()) continue;
                        selection.add(w2);
                    }
                }
            }
        }
        return selection;
    }

    static boolean isCoastline(OsmPrimitive w) {
        return w.hasTag("natural", "water", "coastline") || w.hasTag(LANDUSE, "reservoir");
    }

    static boolean isWaterArea(OsmPrimitive w) {
        return w.hasTag("natural", "water") || w.hasTag(WATERWAY, "riverbank") || w.hasTag(LANDUSE, "reservoir");
    }

    static boolean isWaterAreaOrFairway(OsmPrimitive w) {
        return CrossingWays.isWaterArea(w) || w.hasTag(WATERWAY, "fairway");
    }

    static boolean isHighway(OsmPrimitive w) {
        return w.hasTagDifferent(HIGHWAY, "rest_area", "services", "bus_stop", "platform");
    }

    static boolean isRailway(OsmPrimitive w) {
        return w.hasKey(RAILWAY) && !CrossingWays.isSubwayOrTramOrRazed(w);
    }

    static boolean isSubwayOrTramOrRazed(OsmPrimitive w) {
        return w.hasTag(RAILWAY, "subway", "tram", "razed") || w.hasTag(RAILWAY, "construction") && w.hasTag("construction", "tram") || w.hasTag(RAILWAY, "disused") && w.hasTag("disused", "tram");
    }

    static boolean isProposedOrAbandoned(OsmPrimitive w) {
        return w.hasTag(HIGHWAY, "proposed") || w.hasTag(RAILWAY, "proposed", "abandoned");
    }

    abstract boolean ignoreWaySegmentCombination(Way var1, Way var2);

    MessageHelper createMessage(Way w1, Way w2) {
        return new MessageHelper(this.name, this.code);
    }

    @Override
    public void visit(Way w) {
        this.waysToTest.add(w);
    }

    private void testWay(Way w) {
        boolean findSelfCrossingOnly = this instanceof SelfCrossing;
        if (findSelfCrossingOnly) {
            this.cellSegments.clear();
            this.seenWays.clear();
        }
        int nodesSize = w.getNodesCount();
        for (int i = 0; i < nodesSize - 1; ++i) {
            WaySegment es1 = new WaySegment(w, i);
            if (!((Node)es1.getFirstNode()).isLatLonKnown() || !((Node)es1.getSecondNode()).isLatLonKnown()) {
                Logging.warn("Crossing ways test skipped " + String.valueOf(es1));
                continue;
            }
            for (List<WaySegment> segments : CrossingWays.getSegments(this.cellSegments, es1.getFirstNode(), es1.getSecondNode())) {
                for (WaySegment es2 : segments) {
                    List<WaySegment> highlight;
                    if (!es1.intersects(es2) || !findSelfCrossingOnly && this.ignoreWaySegmentCombination((Way)es1.getWay(), (Way)es2.getWay())) continue;
                    ArrayList<Way> prims = new ArrayList<Way>();
                    prims.add((Way)es1.getWay());
                    if (es1.getWay() != es2.getWay()) {
                        prims.add((Way)es2.getWay());
                    }
                    if ((highlight = this.seenWays.get(prims)) == null) {
                        highlight = new ArrayList<WaySegment>();
                        highlight.add(es1);
                        highlight.add(es2);
                        MessageHelper message = this.createMessage((Way)es1.getWay(), (Way)es2.getWay());
                        this.errors.add(TestError.builder(this, Severity.WARNING, message.code).message(message.message).primitives(prims).highlightWaySegments(highlight).build());
                        this.seenWays.put(prims, highlight);
                        continue;
                    }
                    highlight.add(es1);
                    highlight.add(es2);
                }
                segments.add(es1);
            }
        }
    }

    private static boolean areLayerOrLevelDifferent(Way w1, Way w2) {
        return !Objects.equals(OsmUtils.getLayer(w1), OsmUtils.getLayer(w2)) || !Objects.equals(w1.get("level"), w2.get("level"));
    }

    public static List<List<WaySegment>> getSegments(Map<Point2D, List<WaySegment>> cellSegments, EastNorth n1, EastNorth n2) {
        return ValUtil.getSegmentCells(n1, n2, OsmValidator.getGridDetail()).stream().map(cell -> cellSegments.computeIfAbsent((Point2D)cell, k -> new ArrayList())).collect(Collectors.toList());
    }

    public static List<List<WaySegment>> getSegments(Map<Point2D, List<WaySegment>> cellSegments, ILatLon n1, ILatLon n2) {
        return ValUtil.getSegmentCells(n1, n2, OsmValidator.getGridDetail()).stream().map(cell -> cellSegments.computeIfAbsent((Point2D)cell, k -> new ArrayList())).collect(Collectors.toList());
    }

    public static void findIntersectingWay(Way w, Map<Point2D, List<WaySegment>> cellSegments, Map<List<Way>, List<WaySegment>> crossingWays, boolean findSharedWaySegments) {
        int nodesSize = w.getNodesCount();
        for (int i = 0; i < nodesSize - 1; ++i) {
            WaySegment es1 = new WaySegment(w, i);
            EastNorth en1 = ((Node)es1.getFirstNode()).getEastNorth();
            EastNorth en2 = ((Node)es1.getSecondNode()).getEastNorth();
            if (en1 == null || en2 == null) {
                Logging.warn("Crossing ways test skipped " + String.valueOf(es1));
                continue;
            }
            for (List<WaySegment> segments : CrossingWays.getSegments(cellSegments, en1, en2)) {
                for (WaySegment es2 : segments) {
                    if (es2.getWay() == w || findSharedWaySegments && !es1.isSimilar(es2) || !findSharedWaySegments && !es1.intersects(es2)) continue;
                    List<Way> prims = Arrays.asList((Way)es1.getWay(), (Way)es2.getWay());
                    List<WaySegment> highlight = crossingWays.get(prims);
                    if (highlight == null) {
                        highlight = new ArrayList<WaySegment>(2);
                        highlight.add(es1);
                        highlight.add(es2);
                        crossingWays.put(prims, highlight);
                        continue;
                    }
                    highlight.add(es1);
                    highlight.add(es2);
                }
                segments.add(es1);
            }
        }
    }

    public static boolean isSelfCrossing(Way way) {
        CheckParameterUtil.ensureParameterNotNull(way, "way");
        SelfCrossing test = new SelfCrossing();
        test.visit(way);
        test.runTest();
        return !test.getErrors().isEmpty();
    }

    public static class SelfCrossing
    extends CrossingWays {
        protected static final int CROSSING_SELF = 604;

        public SelfCrossing() {
            super(I18n.tr("Self crossing ways", new Object[0]), 604);
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            return false;
        }
    }

    public static class Boundaries
    extends CrossingWays {
        protected static final int CROSSING_BOUNDARIES = 602;

        public Boundaries() {
            super(I18n.tr("Crossing boundaries", new Object[0]), 602);
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("boundary") && !p.hasTag("boundary", "protected_area") && (!(p instanceof Relation) || p.isMultipolygon());
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            Set<String> s1 = Boundaries.getBoundaryTags(w1);
            Set<String> s2 = Boundaries.getBoundaryTags(w2);
            return s1.stream().noneMatch(s2::contains);
        }

        private static Set<String> getBoundaryTags(Way w) {
            HashSet<String> types = new HashSet<String>();
            String type = w.get("boundary");
            if (type != null) {
                types.add(type);
            }
            w.referrers(Relation.class).filter(IRelation::isMultipolygon).map(r -> r.get("boundary")).filter(Objects::nonNull).forEach(types::add);
            types.remove("protected_area");
            return types;
        }

        @Override
        public void visit(Relation r) {
            for (Way w : r.getMemberPrimitives(Way.class)) {
                if (w.isIncomplete()) continue;
                this.visit(w);
            }
        }
    }

    static final class MessageHelper {
        final String message;
        final int code;

        MessageHelper(String message, int code) {
            this.message = message;
            this.code = code;
        }
    }

    public static class Ways
    extends CrossingWays {
        protected static final int CROSSING_WAYS = 601;

        public Ways() {
            super(I18n.tr("Crossing ways", new Object[0]), 601);
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive w) {
            return super.isPrimitiveUsable(w) && !Ways.isProposedOrAbandoned(w) && (Ways.isHighway(w) || w.hasKey(CrossingWays.WATERWAY) || Ways.isRailway(w) || Ways.isCoastline(w) || Ways.isBuilding(w) || w.hasKey(CrossingWays.BARRIER) || Ways.isResidentialArea(w));
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            if (w1 == w2) {
                return true;
            }
            if (CrossingWays.areLayerOrLevelDifferent(w1, w2)) {
                return true;
            }
            if (Ways.isBuilding(w1) && Ways.isBuilding(w2)) {
                return true;
            }
            if ((Ways.isResidentialArea(w1) || w1.hasKey(CrossingWays.BARRIER, CrossingWays.HIGHWAY, CrossingWays.RAILWAY, CrossingWays.WATERWAY) || Ways.isWaterArea(w1)) && Ways.isResidentialArea(w2) || (Ways.isResidentialArea(w2) || w2.hasKey(CrossingWays.BARRIER, CrossingWays.HIGHWAY, CrossingWays.RAILWAY, CrossingWays.WATERWAY) || Ways.isWaterArea(w2)) && Ways.isResidentialArea(w1)) {
                return true;
            }
            if (Ways.isWaterArea(w1) && Ways.isWaterArea(w2)) {
                return true;
            }
            if (w1.hasKey(CrossingWays.RAILWAY) && w2.hasKey(CrossingWays.RAILWAY) && (w1.hasTag(CrossingWays.RAILWAY, "yard") != w2.hasTag(CrossingWays.RAILWAY, "yard") || w1.hasTag(CrossingWays.RAILWAY, "halt") != w2.hasTag(CrossingWays.RAILWAY, "halt"))) {
                return true;
            }
            if (w1.hasTag(CrossingWays.WATERWAY, "fairway") && w2.hasTag(CrossingWays.WATERWAY, "fairway")) {
                return true;
            }
            return w1.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && Ways.isWaterAreaOrFairway(w2) || w2.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && Ways.isWaterAreaOrFairway(w1);
        }

        @Override
        MessageHelper createMessage(Way w1, Way w2) {
            WayType[] types = new WayType[]{WayType.of(w1), WayType.of(w2)};
            Arrays.sort((Object[])types);
            if (types[0] == types[1]) {
                switch (types[0]) {
                    case BARRIER: {
                        return new MessageHelper(I18n.tr("Crossing barriers", new Object[0]), 603);
                    }
                    case HIGHWAY: {
                        return new MessageHelper(I18n.tr("Crossing highways", new Object[0]), 620);
                    }
                    case RAILWAY: {
                        return new MessageHelper(I18n.tr("Crossing railways", new Object[0]), 630);
                    }
                    case WATERWAY: {
                        return new MessageHelper(I18n.tr("Crossing waterways", new Object[0]), 650);
                    }
                }
                return new MessageHelper(I18n.tr("Crossing ways", new Object[0]), 601);
            }
            switch (types[0]) {
                case BARRIER: {
                    switch (types[1]) {
                        case BUILDING: {
                            return new MessageHelper(I18n.tr("Crossing barrier/building", new Object[0]), 661);
                        }
                        case HIGHWAY: {
                            return new MessageHelper(I18n.tr("Crossing barrier/highway", new Object[0]), 662);
                        }
                        case RAILWAY: {
                            return new MessageHelper(I18n.tr("Crossing barrier/railway", new Object[0]), 663);
                        }
                        case WATERWAY: {
                            return new MessageHelper(I18n.tr("Crossing barrier/waterway", new Object[0]), 664);
                        }
                    }
                    return new MessageHelper(I18n.tr("Crossing barrier/way", new Object[0]), 665);
                }
                case BUILDING: {
                    switch (types[1]) {
                        case HIGHWAY: {
                            return new MessageHelper(I18n.tr("Crossing building/highway", new Object[0]), 612);
                        }
                        case RAILWAY: {
                            return new MessageHelper(I18n.tr("Crossing building/railway", new Object[0]), 613);
                        }
                        case RESIDENTIAL_AREA: {
                            return new MessageHelper(I18n.tr("Crossing building/residential area", new Object[0]), 614);
                        }
                        case WATERWAY: {
                            return new MessageHelper(I18n.tr("Crossing building/waterway", new Object[0]), 615);
                        }
                    }
                    return new MessageHelper(I18n.tr("Crossing building/way", new Object[0]), 611);
                }
                case HIGHWAY: {
                    switch (types[1]) {
                        case RAILWAY: {
                            return new MessageHelper(I18n.tr("Crossing highway/railway", new Object[0]), 622);
                        }
                        case WATERWAY: {
                            return new MessageHelper(I18n.tr("Crossing highway/waterway", new Object[0]), 623);
                        }
                    }
                    return new MessageHelper(I18n.tr("Crossing highway/way", new Object[0]), 621);
                }
                case RAILWAY: {
                    switch (types[1]) {
                        case WATERWAY: {
                            return new MessageHelper(I18n.tr("Crossing railway/waterway", new Object[0]), 632);
                        }
                    }
                    return new MessageHelper(I18n.tr("Crossing railway/way", new Object[0]), 631);
                }
                case RESIDENTIAL_AREA: {
                    return new MessageHelper(I18n.tr("Crossing residential area/way", new Object[0]), 641);
                }
            }
            return new MessageHelper(I18n.tr("Crossing waterway/way", new Object[0]), 651);
        }
    }

    private static enum WayType {
        BARRIER,
        BUILDING,
        HIGHWAY,
        RAILWAY,
        RESIDENTIAL_AREA,
        WATERWAY,
        WAY;


        static WayType of(Way w) {
            if (w.hasKey(CrossingWays.BARRIER)) {
                return BARRIER;
            }
            if (CrossingWays.isBuilding(w)) {
                return BUILDING;
            }
            if (w.hasKey(CrossingWays.HIGHWAY)) {
                return HIGHWAY;
            }
            if (CrossingWays.isRailway(w)) {
                return RAILWAY;
            }
            if (CrossingWays.isResidentialArea(w)) {
                return RESIDENTIAL_AREA;
            }
            if (w.hasKey(CrossingWays.WATERWAY)) {
                return WATERWAY;
            }
            return WAY;
        }
    }
}

