/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.StyleCache;

public abstract class PrimitiveData
extends AbstractPrimitive
implements Serializable {
    private static final long serialVersionUID = -1044837092478109138L;

    protected PrimitiveData(long id) {
        this.id = id;
    }

    protected PrimitiveData(PrimitiveData data) {
        this.cloneFrom(data);
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setIncomplete(boolean incomplete) {
        super.setIncomplete(incomplete);
    }

    public abstract PrimitiveData makeCopy();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(' ').append(Arrays.toString(this.keys)).append(' ').append(this.getFlagsAsString());
        return builder.toString();
    }

    @Override
    protected final void keysChangedImpl(Map<String, String> originalKeys) {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeLong(this.id);
        oos.writeLong(this.user == null ? -1L : this.user.getId());
        oos.writeInt(this.version);
        oos.writeInt(this.changesetId);
        oos.writeInt(this.timestamp);
        oos.writeObject(this.keys);
        oos.writeShort(this.flags);
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.id = ois.readLong();
        long userId = ois.readLong();
        this.user = userId == -1L ? null : User.getById(userId);
        this.version = ois.readInt();
        this.changesetId = ois.readInt();
        this.timestamp = ois.readInt();
        this.keys = (String[])ois.readObject();
        this.flags = ois.readShort();
        ois.defaultReadObject();
    }

    @Override
    public boolean isTagged() {
        return this.hasKeys();
    }

    @Override
    public boolean isAnnotated() {
        return false;
    }

    @Override
    public boolean hasDirectionKeys() {
        return false;
    }

    @Override
    public boolean reversedDirection() {
        return false;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
    }

    @Override
    public boolean isHighlighted() {
        return false;
    }

    public final List<PrimitiveData> getReferrers(boolean allowWithoutDataset) {
        return Collections.emptyList();
    }

    @Override
    public void visitReferrers(PrimitiveVisitor visitor) {
    }

    @Override
    public OsmData<?, ?, ?, ?> getDataSet() {
        return null;
    }

    @Override
    public StyleCache getCachedStyle(ElemStyles styles) {
        return null;
    }

    @Override
    public void setCachedStyle(ElemStyles styles, StyleCache mappaintStyle) {
    }

    @Override
    public boolean isCachedStyleUpToDate(ElemStyles styles) {
        return false;
    }

    @Override
    public void declareCachedStyleUpToDate(ElemStyles styles) {
    }

    @Override
    public void clearCachedStyle() {
    }
}

