/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class SplitWayCommand
extends SequenceCommand {
    private static volatile Consumer<String> warningNotifier = Logging::warn;
    private static final String DOWNLOAD_MISSING_PREF_KEY = "split_way_download_missing_members";
    private final List<? extends PrimitiveId> newSelection;
    private final Way originalWay;
    private final List<Way> newWays;
    private static final String RESTRICTION = "restriction";
    private static final Map<String, String> relationSpecialTypes = new HashMap<String, String>();

    public static void setWarningNotifier(Consumer<String> notifier) {
        warningNotifier = Objects.requireNonNull(notifier);
    }

    public SplitWayCommand(String name, Collection<Command> commandList, List<? extends PrimitiveId> newSelection, Way originalWay, List<Way> newWays) {
        super(name, commandList);
        this.newSelection = newSelection;
        this.originalWay = originalWay;
        this.newWays = newWays;
    }

    public List<? extends PrimitiveId> getNewSelection() {
        return this.newSelection;
    }

    public Way getOriginalWay() {
        return this.originalWay;
    }

    public List<Way> getNewWays() {
        return this.newWays;
    }

    public static List<List<Node>> buildSplitChunks(Way wayToSplit, List<Node> splitPoints) {
        CheckParameterUtil.ensureParameterNotNull(wayToSplit, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(splitPoints, "splitPoints");
        HashSet<Node> nodeSet = new HashSet<Node>(splitPoints);
        LinkedList<List<Node>> wayChunks = new LinkedList<List<Node>>();
        ArrayList<Node> currentWayChunk = new ArrayList<Node>();
        wayChunks.add(currentWayChunk);
        Iterator<Node> it = wayToSplit.getNodes().iterator();
        while (it.hasNext()) {
            Node currentNode = it.next();
            boolean atEndOfWay = currentWayChunk.isEmpty() || !it.hasNext();
            currentWayChunk.add(currentNode);
            if (!nodeSet.contains(currentNode) || atEndOfWay) continue;
            currentWayChunk = new ArrayList();
            currentWayChunk.add(currentNode);
            wayChunks.add(currentWayChunk);
        }
        List lastWayChunk = (List)wayChunks.get(wayChunks.size() - 1);
        if (wayChunks.size() >= 2 && ((List)wayChunks.get(0)).get(0) == lastWayChunk.get(lastWayChunk.size() - 1) && !nodeSet.contains(((List)wayChunks.get(0)).get(0))) {
            if (wayChunks.size() == 2) {
                warningNotifier.accept(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0]));
                return null;
            }
            lastWayChunk.remove(lastWayChunk.size() - 1);
            lastWayChunk.addAll((Collection)wayChunks.get(0));
            wayChunks.remove(wayChunks.size() - 1);
            wayChunks.set(0, lastWayChunk);
        }
        if (wayChunks.size() < 2) {
            if (((List)wayChunks.get(0)).get(0) == ((List)wayChunks.get(0)).get(((List)wayChunks.get(0)).size() - 1)) {
                warningNotifier.accept(I18n.tr("You must select two or more nodes to split a circular way.", new Object[0]));
            } else {
                warningNotifier.accept(I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)", new Object[0]));
            }
            return null;
        }
        return wayChunks;
    }

    public static List<Way> createNewWaysFromChunks(Way way, Iterable<List<Node>> wayChunks) {
        ArrayList<Way> newWays = new ArrayList<Way>();
        for (List<Node> wayChunk : wayChunks) {
            Way wayToAdd = new Way();
            wayToAdd.setKeys(way.getKeys());
            wayToAdd.setNodes(wayChunk);
            newWays.add(wayToAdd);
        }
        return newWays;
    }

    public static SplitWayCommand splitWay(Way way, List<List<Node>> wayChunks, Collection<? extends OsmPrimitive> selection) {
        return SplitWayCommand.splitWay(way, wayChunks, selection, Strategy.keepLongestChunk());
    }

    public static SplitWayCommand splitWay(Way way, List<List<Node>> wayChunks, Collection<? extends OsmPrimitive> selection, Strategy splitStrategy) {
        return SplitWayCommand.splitWay(way, wayChunks, selection, splitStrategy, WhenRelationOrderUncertain.ASK_USER_FOR_CONSENT_TO_DOWNLOAD).orElse(null);
    }

    public static Optional<SplitWayCommand> splitWay(Way way, List<List<Node>> wayChunks, Collection<? extends OsmPrimitive> selection, Strategy splitStrategy, WhenRelationOrderUncertain whenRelationOrderUncertain) {
        ArrayList<OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(selection.size() + wayChunks.size());
        newSelection.addAll(selection);
        List<Way> newWays = SplitWayCommand.createNewWaysFromChunks(way, wayChunks);
        Way wayToKeep = splitStrategy.determineWayToKeep(newWays);
        return wayToKeep != null ? SplitWayCommand.doSplitWay(way, wayToKeep, newWays, newSelection, whenRelationOrderUncertain) : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<SplitWayCommand> doSplitWay(Way way, Way wayToKeep, List<Way> newWays, List<OsmPrimitive> newSelection, WhenRelationOrderUncertain whenRelationOrderUncertain) {
        if (whenRelationOrderUncertain == null) {
            whenRelationOrderUncertain = WhenRelationOrderUncertain.ASK_USER_FOR_CONSENT_TO_DOWNLOAD;
        }
        int indexOfWayToKeep = newWays.indexOf(wayToKeep);
        newWays.remove(wayToKeep);
        Analysis analysis = SplitWayCommand.analyseSplit(way, wayToKeep, newWays);
        HashSet<Relation> relationsNeedingMoreMembers = new HashSet<Relation>();
        HashSet<OsmPrimitive> incompleteMembers = new HashSet<OsmPrimitive>();
        for (RelationAnalysis relationAnalysis : analysis.getRelationAnalyses()) {
            if (relationAnalysis.getNeededIncompleteMembers().isEmpty()) continue;
            incompleteMembers.addAll(relationAnalysis.getNeededIncompleteMembers());
            relationsNeedingMoreMembers.add(relationAnalysis.getRelation());
        }
        MissingMemberStrategy missingMemberStrategy = MissingMemberStrategy.USER_ABORTED;
        if (relationsNeedingMoreMembers.isEmpty()) {
            missingMemberStrategy = MissingMemberStrategy.GO_AHEAD_WITHOUT_DOWNLOADS;
        } else {
            switch (whenRelationOrderUncertain) {
                case ASK_USER_FOR_CONSENT_TO_DOWNLOAD: {
                    if (ConditionalOptionPaneUtil.getDialogReturnValue(DOWNLOAD_MISSING_PREF_KEY) == Integer.MAX_VALUE) {
                        missingMemberStrategy = MissingMemberStrategy.GO_AHEAD_WITH_DOWNLOADS;
                        break;
                    }
                    missingMemberStrategy = SplitWayCommand.offerToDownloadMissingMembersIfNeeded(analysis, relationsNeedingMoreMembers.size());
                    break;
                }
                case SPLIT_ANYWAY: {
                    missingMemberStrategy = MissingMemberStrategy.GO_AHEAD_WITHOUT_DOWNLOADS;
                    break;
                }
                case DOWNLOAD_MISSING_MEMBERS: {
                    missingMemberStrategy = MissingMemberStrategy.GO_AHEAD_WITH_DOWNLOADS;
                    break;
                }
                case ABORT: {
                    missingMemberStrategy = MissingMemberStrategy.USER_ABORTED;
                }
            }
        }
        try {
            Optional<SplitWayCommand> optional;
            switch (missingMemberStrategy) {
                case GO_AHEAD_WITH_DOWNLOADS: {
                    try {
                        SplitWayCommand.downloadMissingMembers(incompleteMembers);
                    }
                    catch (OsmTransferException e) {
                        ExceptionDialogUtil.explainException(e);
                        Optional<SplitWayCommand> optional2 = Optional.empty();
                        wayToKeep.setNodes((List<Node>)null);
                        analysis.cleanup();
                        return optional2;
                    }
                    analysis.cleanup();
                    analysis = SplitWayCommand.analyseSplit(way, wayToKeep, newWays);
                    break;
                }
                case GO_AHEAD_WITHOUT_DOWNLOADS: {
                    break;
                }
                case USER_ABORTED: {
                    optional = Optional.empty();
                    return optional;
                }
            }
            optional = Optional.of(SplitWayCommand.splitBasedOnAnalyses(way, newWays, newSelection, analysis, indexOfWayToKeep));
            return optional;
        }
        finally {
            wayToKeep.setNodes((List<Node>)null);
            analysis.cleanup();
        }
    }

    static Analysis analyseSplit(Way way, Way wayToKeep, List<Way> newWays) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        List<String> nowarnroles = Config.getPref().getList("way.split.roles.nowarn", Arrays.asList("outer", "inner", "forward", "backward", "north", "south", "east", "west"));
        List<Node> changedWayNodes = wayToKeep.getNodes();
        commandList.add(new ChangeNodesCommand(way, changedWayNodes));
        for (Way wayToAdd : newWays) {
            commandList.add(new AddCommand(way.getDataSet(), wayToAdd));
        }
        ArrayList<RelationAnalysis> relationAnalyses = new ArrayList<RelationAnalysis>();
        EnumSet<WarningType> warnings = EnumSet.noneOf(WarningType.class);
        int numberOfRelations = 0;
        for (Relation r : OsmPrimitive.getParentRelations(Collections.singleton(way))) {
            if (!r.isUsable()) continue;
            ++numberOfRelations;
            boolean isSimpleCase = true;
            Relation c = null;
            String type = Optional.ofNullable(r.get("type")).orElse("");
            boolean isOrderedRelation = "route".equals(type) || "multipolygon".equals(type) || "boundary".equals(type);
            for (int ir = 0; ir < r.getMembersCount(); ++ir) {
                Set<Object> missingWays;
                Direction direction;
                RelationMember rm;
                block30: {
                    block28: {
                        Way w;
                        block29: {
                            rm = r.getMember(ir);
                            if (rm.getMember() != way) continue;
                            boolean insert = true;
                            if (relationSpecialTypes.containsKey(type) && RESTRICTION.equals(relationSpecialTypes.get(type))) {
                                RelationInformation rValue = SplitWayCommand.treatAsRestriction(r, rm, c, newWays, way, changedWayNodes);
                                if (rValue.warnme) {
                                    warnings.add(WarningType.GENERIC);
                                }
                                insert = rValue.insert;
                                c = rValue.relation;
                            } else if (!isOrderedRelation) {
                                warnings.add(WarningType.GENERIC);
                            }
                            if (!insert) continue;
                            if (c == null) {
                                c = new Relation(r);
                            }
                            if (rm.hasRole() && !nowarnroles.contains(rm.getRole())) {
                                warnings.add(WarningType.ROLE);
                            }
                            direction = Direction.UNKNOWN;
                            missingWays = new HashSet();
                            if (!isOrderedRelation) break block28;
                            if (way.lastNode() != way.firstNode()) break block29;
                            direction = direction.merge(Direction.IRRELEVANT);
                            break block30;
                        }
                        if (ir - 1 >= 0 && r.getMember(ir - 1).isWay()) {
                            w = r.getMember(ir - 1).getWay();
                            if (w.isIncomplete()) {
                                missingWays.add(w);
                            } else if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                direction = direction.merge(Direction.FORWARDS);
                            } else if (w.firstNode() == way.lastNode() || w.lastNode() == way.lastNode()) {
                                direction = direction.merge(Direction.BACKWARDS);
                            }
                        }
                        if (ir + 1 < r.getMembersCount() && r.getMember(ir + 1).isWay()) {
                            w = r.getMember(ir + 1).getWay();
                            if (w.isIncomplete()) {
                                missingWays.add(w);
                            } else if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                direction = direction.merge(Direction.BACKWARDS);
                            } else if (w.firstNode() == way.lastNode() || w.lastNode() == way.lastNode()) {
                                direction = direction.merge(Direction.FORWARDS);
                            }
                        }
                        if (direction != Direction.UNKNOWN || !missingWays.isEmpty()) break block30;
                        direction = Direction.IRRELEVANT;
                        break block30;
                    }
                    int k = 1;
                    while (ir - k >= 0 || ir + k < r.getMembersCount()) {
                        Way w;
                        if (ir - k >= 0 && r.getMember(ir - k).isWay()) {
                            w = r.getMember(ir - k).getWay();
                            if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                direction = direction.merge(Direction.FORWARDS);
                                break;
                            }
                            if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                            direction = direction.merge(Direction.BACKWARDS);
                            break;
                        }
                        if (ir + k < r.getMembersCount() && r.getMember(ir + k).isWay()) {
                            w = r.getMember(ir + k).getWay();
                            if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                direction = direction.merge(Direction.BACKWARDS);
                                break;
                            }
                            if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                            direction = direction.merge(Direction.FORWARDS);
                            break;
                        }
                        ++k;
                    }
                }
                if (direction != Direction.UNKNOWN) {
                    missingWays = Collections.emptySet();
                }
                relationAnalyses.add(new RelationAnalysis(c, rm, direction, missingWays));
                isSimpleCase = false;
            }
            if (c == null || !isSimpleCase) continue;
            if (!r.getMembers().equals(c.getMembers())) {
                commandList.add(new ChangeMembersCommand(r, new ArrayList<RelationMember>(c.getMembers())));
            }
            c.setMembers((List<RelationMember>)null);
        }
        return new Analysis(relationAnalyses, commandList, warnings, numberOfRelations);
    }

    static MissingMemberStrategy offerToDownloadMissingMembersIfNeeded(Analysis analysis, int numRelationsNeedingMoreMembers) {
        Object[] options = new String[]{I18n.tr("Yes, download the missing members", new Object[0]), I18n.tr("No, abort the split operation", new Object[0]), I18n.tr("No, perform the split without downloading", new Object[0])};
        String msgMemberOfRelations = I18n.trn("This way is part of a relation.", "This way is part of {0} relations.", analysis.getNumberOfRelations(), analysis.getNumberOfRelations());
        String msgReferToRelations = analysis.getNumberOfRelations() == 1 ? I18n.tr("this relation", new Object[0]) : (analysis.getNumberOfRelations() == numRelationsNeedingMoreMembers ? I18n.tr("these relations", new Object[0]) : I18n.trn("one relation", "{0} relations", numRelationsNeedingMoreMembers, numRelationsNeedingMoreMembers));
        String msgRelationsMissingData = I18n.tr("For {0} the correct order of the new way parts could not be determined. To fix this, some missing relation members should be downloaded first.", msgReferToRelations);
        JMultilineLabel msg = new JMultilineLabel(msgMemberOfRelations + " " + msgRelationsMissingData);
        msg.setMaxWidth(600);
        int ret = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Download missing relation members?", new Object[0]), 2, 3, null, options, options[0]);
        switch (ret) {
            case 0: {
                ConditionalOptionPaneUtil.showMessageDialog(DOWNLOAD_MISSING_PREF_KEY, MainApplication.getMainFrame(), I18n.tr("Missing relation members will be downloaded. Should this be done automatically from now on?", new Object[0]), I18n.tr("Downloading missing relation members", new Object[0]), 1);
                return MissingMemberStrategy.GO_AHEAD_WITH_DOWNLOADS;
            }
            case 2: {
                return MissingMemberStrategy.GO_AHEAD_WITHOUT_DOWNLOADS;
            }
        }
        return MissingMemberStrategy.USER_ABORTED;
    }

    static void downloadMissingMembers(Set<OsmPrimitive> incompleteMembers) throws OsmTransferException {
        MultiFetchServerObjectReader reader = MultiFetchServerObjectReader.create();
        reader.append(incompleteMembers);
        DataSet ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
        MainApplication.getLayerManager().getEditLayer().mergeFrom(ds);
    }

    static SplitWayCommand splitBasedOnAnalyses(Way way, List<Way> newWays, List<OsmPrimitive> newSelection, Analysis analysis, int indexOfWayToKeep) {
        if (newSelection != null && !newSelection.contains(way)) {
            newSelection.add(way);
        }
        if (newSelection != null) {
            newSelection.addAll(newWays);
        }
        block0: for (RelationAnalysis relationAnalysis : analysis.getRelationAnalyses()) {
            RelationMember rm = relationAnalysis.getRelationMember();
            Relation relation = relationAnalysis.getRelation();
            Direction direction = relationAnalysis.getDirection();
            for (int i = 0; i < relation.getMembersCount(); ++i) {
                if (rm != relation.getMember(i)) continue;
                SplitWayCommand.addSortedWays(i, indexOfWayToKeep, direction, newWays, relation);
                continue block0;
            }
        }
        DataSet ds = way.getDataSet();
        for (Relation r : analysis.getRelationAnalyses().stream().map(RelationAnalysis::getRelation).collect(Collectors.toSet())) {
            Relation orig = (Relation)ds.getPrimitiveById(r);
            analysis.getCommands().add(new ChangeMembersCommand(orig, new ArrayList<RelationMember>(r.getMembers())));
            r.setMembers((List<RelationMember>)null);
        }
        EnumSet<WarningType> enumSet = analysis.getWarningTypes();
        if (enumSet.contains((Object)WarningType.ROLE)) {
            warningNotifier.accept(I18n.tr("A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0]));
        } else if (enumSet.contains((Object)WarningType.GENERIC)) {
            warningNotifier.accept(I18n.tr("A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.", new Object[0]));
        }
        return new SplitWayCommand(I18n.trn("Split way {0} into {1} part", "Split way {0} into {1} parts", newWays.size() + 1, way.getDisplayName(DefaultNameFormatter.getInstance()), newWays.size() + 1), analysis.getCommands(), newSelection, way, newWays);
    }

    private static void addSortedWays(int position, int indexOfWayToKeep, Direction direction, List<Way> newWays, Relation relation) {
        if (position < 0) {
            throw new AssertionError((Object)"Relation member not found");
        }
        RelationMember rm = relation.getMember(position);
        boolean reverse = direction == Direction.BACKWARDS || SplitWayCommand.needToReverseSplit(position, indexOfWayToKeep, relation, newWays);
        List<Way> waysToAddBefore = newWays.subList(0, indexOfWayToKeep);
        int j = position;
        for (Way wayToAdd : waysToAddBefore) {
            RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
            ++j;
            if (reverse) {
                relation.addMember(position + 1, em);
                continue;
            }
            relation.addMember(j - 1, em);
        }
        List<Way> waysToAddAfter = newWays.subList(indexOfWayToKeep, newWays.size());
        for (Way wayToAdd : waysToAddAfter) {
            RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
            ++j;
            if (reverse) {
                relation.addMember(position, em);
                continue;
            }
            relation.addMember(j, em);
        }
    }

    private static boolean needToReverseSplit(int position, int indexOfWayToKeep, Relation relation, List<Way> newWays) {
        Way compare;
        Way last;
        RelationMember rm = relation.getMember(position);
        if (!rm.isWay()) {
            return false;
        }
        RelationMember previous = position <= 0 ? null : relation.getMember(position - 1);
        RelationMember next = position + 1 >= relation.getMembersCount() ? null : relation.getMember(position + 1);
        Way first = indexOfWayToKeep == 0 ? rm.getWay() : newWays.get(0);
        Way way = last = indexOfWayToKeep == newWays.size() ? rm.getWay() : newWays.get(newWays.size() - 1);
        if (previous != null && previous.isWay() && previous.getWay().isUsable() && !(compare = previous.getWay()).isFirstLastNode(first.firstNode()) && !compare.isFirstLastNode(first.lastNode())) {
            return true;
        }
        if (next != null && next.isWay() && next.getWay().isUsable()) {
            compare = next.getWay();
            return !compare.isFirstLastNode(last.firstNode()) && !compare.isFirstLastNode(last.lastNode());
        }
        return false;
    }

    private static RelationInformation treatAsRestriction(Relation r, RelationMember rm, Relation c, Collection<Way> newWays, Way way, List<Node> changedWayNodes) {
        RelationInformation relationInformation = new RelationInformation();
        String role = rm.getRole();
        String type = Optional.ofNullable(r.get("type")).orElse("");
        if ("from".equals(role) || "to".equals(role)) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (OsmPrimitive osmPrimitive : SplitWayCommand.findVias(r, type)) {
                if (osmPrimitive instanceof Node) {
                    nodes.add((Node)osmPrimitive);
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                nodes.add(((Way)osmPrimitive).lastNode());
                nodes.add(((Way)osmPrimitive).firstNode());
            }
            Way res = null;
            for (Node n : nodes) {
                if (changedWayNodes.get(0) != n && changedWayNodes.get(changedWayNodes.size() - 1) != n) continue;
                res = way;
            }
            if (res == null) {
                for (Way wayToAdd : newWays) {
                    for (Node n : nodes) {
                        if (!wayToAdd.isFirstLastNode(n)) continue;
                        res = wayToAdd;
                    }
                }
                if (res != null) {
                    if (c == null) {
                        c = new Relation(r);
                    }
                    c.addMember(new RelationMember(role, res));
                    c.removeMembersFor(way);
                }
            }
        } else if (!"via".equals(role)) {
            relationInformation.warnme = true;
        } else {
            relationInformation.insert = true;
        }
        relationInformation.relation = c;
        return relationInformation;
    }

    static List<? extends OsmPrimitive> findVias(Relation r, String type) {
        if (type != null) {
            switch (type) {
                case "connectivity": 
                case "restriction": {
                    return r.findRelationMembers("via");
                }
                case "destination_sign": {
                    List<? extends OsmPrimitive> intersections = r.findRelationMembers("intersection");
                    return intersections.isEmpty() ? r.findRelationMembers("sign") : intersections;
                }
            }
        }
        return Collections.emptyList();
    }

    public static SplitWayCommand split(Way way, List<Node> atNodes, Collection<? extends OsmPrimitive> selection) {
        List<List<Node>> chunks = SplitWayCommand.buildSplitChunks(way, atNodes);
        return chunks != null ? SplitWayCommand.splitWay(way, chunks, selection) : null;
    }

    public static String addSpecialRelationType(String relationType, String treatAs) {
        return relationSpecialTypes.put(relationType, treatAs);
    }

    public static Map<String, String> getSpecialRelationTypes() {
        return relationSpecialTypes;
    }

    static {
        relationSpecialTypes.put(RESTRICTION, RESTRICTION);
        relationSpecialTypes.put("destination_sign", RESTRICTION);
        relationSpecialTypes.put("connectivity", RESTRICTION);
    }

    @FunctionalInterface
    public static interface Strategy {
        public Way determineWayToKeep(Iterable<Way> var1);

        public static Strategy keepLongestChunk() {
            return wayChunks -> {
                Way wayToKeep = null;
                for (Way i : wayChunks) {
                    if (wayToKeep != null && i.getNodesCount() <= wayToKeep.getNodesCount()) continue;
                    wayToKeep = i;
                }
                return wayToKeep;
            };
        }

        public static Strategy keepFirstChunk() {
            return wayChunks -> (Way)wayChunks.iterator().next();
        }
    }

    public static enum WhenRelationOrderUncertain {
        ASK_USER_FOR_CONSENT_TO_DOWNLOAD,
        ABORT,
        SPLIT_ANYWAY,
        DOWNLOAD_MISSING_MEMBERS;

    }

    static class Analysis {
        List<RelationAnalysis> relationAnalyses;
        Collection<Command> commands;
        EnumSet<WarningType> warningTypes;
        private final int numberOfRelations;

        Analysis(List<RelationAnalysis> relationAnalyses, Collection<Command> commandList, EnumSet<WarningType> warnings, int numberOfRelations) {
            this.relationAnalyses = relationAnalyses;
            this.commands = commandList;
            this.warningTypes = warnings;
            this.numberOfRelations = numberOfRelations;
        }

        void cleanup() {
            for (RelationAnalysis ra : this.relationAnalyses) {
                if (ra.relation.getDataSet() != null) continue;
                ra.relation.setMembers((List<RelationMember>)null);
            }
        }

        List<RelationAnalysis> getRelationAnalyses() {
            return this.relationAnalyses;
        }

        Collection<Command> getCommands() {
            return this.commands;
        }

        EnumSet<WarningType> getWarningTypes() {
            return this.warningTypes;
        }

        public int getNumberOfRelations() {
            return this.numberOfRelations;
        }
    }

    static class RelationAnalysis {
        private final Relation relation;
        private final RelationMember relationMember;
        private final Direction direction;
        private final Set<Way> neededIncompleteMembers;

        RelationAnalysis(Relation relation, RelationMember relationMember, Direction direction, Set<Way> neededIncompleteMembers) {
            this.relation = relation;
            this.relationMember = relationMember;
            this.direction = direction;
            this.neededIncompleteMembers = neededIncompleteMembers;
        }

        RelationMember getRelationMember() {
            return this.relationMember;
        }

        Direction getDirection() {
            return this.direction;
        }

        public Set<Way> getNeededIncompleteMembers() {
            return this.neededIncompleteMembers;
        }

        Relation getRelation() {
            return this.relation;
        }
    }

    static enum MissingMemberStrategy {
        GO_AHEAD_WITH_DOWNLOADS,
        GO_AHEAD_WITHOUT_DOWNLOADS,
        USER_ABORTED;

    }

    static enum WarningType {
        GENERIC,
        ROLE;

    }

    private static final class RelationInformation {
        boolean warnme;
        boolean insert;
        Relation relation;

        private RelationInformation() {
        }
    }

    static enum Direction {
        FORWARDS,
        BACKWARDS,
        UNKNOWN,
        IRRELEVANT;


        Direction merge(Direction other) {
            if (this == other) {
                return this;
            }
            if (this == IRRELEVANT || other == IRRELEVANT || this == FORWARDS && other == BACKWARDS || other == FORWARDS && this == BACKWARDS) {
                return IRRELEVANT;
            }
            if (this == UNKNOWN) {
                return other;
            }
            if (other == UNKNOWN) {
                return this;
            }
            return UNKNOWN;
        }
    }
}

