/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.Month;
import ch.poole.openinghoursparser.Util;
import ch.poole.openinghoursparser.VarDate;
import ch.poole.openinghoursparser.WeekDay;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class DateWithOffset
extends Element {
    private static final int MAX_NTH = 5;
    public static final int UNDEFINED_MONTH_DAY = Integer.MIN_VALUE;
    public static final int MIN_MONTH_DAY = 1;
    public static final int MAX_MONTH_DAY = 31;
    boolean openEnded = false;
    int year = Integer.MIN_VALUE;
    Month month = null;
    int day = Integer.MIN_VALUE;
    WeekDay nthWeekDay = null;
    int nth = 0;
    boolean weekDayOffsetPositive = true;
    WeekDay weekDayOffset = null;
    int dayOffset = 0;
    VarDate varDate = null;

    public DateWithOffset() {
    }

    public DateWithOffset(@NotNull DateWithOffset dwo) {
        this.openEnded = dwo.openEnded;
        this.year = dwo.year;
        this.month = dwo.month;
        this.day = dwo.day;
        this.nthWeekDay = dwo.nthWeekDay;
        this.nth = dwo.nth;
        this.weekDayOffsetPositive = dwo.weekDayOffsetPositive;
        this.weekDayOffset = dwo.weekDayOffset;
        this.dayOffset = dwo.dayOffset;
        this.varDate = dwo.varDate;
    }

    public boolean undefinedDay() {
        return this.day == Integer.MIN_VALUE && this.nthWeekDay == null && this.weekDayOffset == null && this.varDate == null;
    }

    public boolean undefinedYear() {
        return this.year == Integer.MIN_VALUE;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this.undefinedYear()) {
            b.append(this.year);
        }
        if (this.month != null) {
            this.addSpaceIfYearisPresent(b);
            b.append((Object)this.month);
        }
        if (this.nthWeekDay != null) {
            if (this.month != null) {
                b.append(" ");
            }
            b.append((Object)this.nthWeekDay);
            b.append('[');
            b.append(this.nth);
            b.append(']');
        }
        if (this.day != Integer.MIN_VALUE) {
            if (!this.undefinedYear() || this.month != null) {
                b.append(" ");
            }
            b.append(String.format(Locale.US, "%02d", this.day));
        } else if (this.varDate != null) {
            this.addSpaceIfYearisPresent(b);
            b.append((Object)this.varDate);
        }
        if (this.weekDayOffset != null) {
            if (this.weekDayOffsetPositive) {
                b.append("+");
            } else {
                b.append("-");
            }
            b.append((Object)this.weekDayOffset);
        }
        if (this.dayOffset != 0) {
            b.append(this.dayOffset > 0 ? " +" : " -");
            b.append(String.format(Locale.US, "%d", Math.abs(this.dayOffset)));
            b.append(" day");
            if (Math.abs(this.dayOffset) > 1) {
                b.append("s");
            }
        }
        if (this.openEnded) {
            b.append("+");
        }
        return b.toString();
    }

    private void addSpaceIfYearisPresent(@NotNull StringBuilder b) {
        if (!this.undefinedYear()) {
            b.append(" ");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof DateWithOffset) {
            DateWithOffset o = (DateWithOffset)other;
            return this.openEnded == o.openEnded && this.year == o.year && Util.equals((Object)this.month, (Object)o.month) && Util.equals((Object)this.nthWeekDay, (Object)o.nthWeekDay) && this.nth == o.nth && this.day == o.day && this.weekDayOffsetPositive == o.weekDayOffsetPositive && Util.equals((Object)this.weekDayOffset, (Object)o.weekDayOffset) && this.dayOffset == o.dayOffset && Util.equals((Object)this.varDate, (Object)o.varDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.openEnded ? 0 : 1);
        result = 37 * result + this.year;
        result = 37 * result + (this.month == null ? 0 : this.month.hashCode());
        result = 37 * result + (this.nthWeekDay == null ? 0 : this.nthWeekDay.hashCode());
        result = 37 * result + this.nth;
        result = 37 * result + this.day;
        result = 37 * result + (this.weekDayOffsetPositive ? 0 : 1);
        result = 37 * result + (this.weekDayOffset == null ? 0 : this.weekDayOffset.hashCode());
        result = 37 * result + this.dayOffset;
        result = 37 * result + (this.varDate == null ? 0 : this.varDate.hashCode());
        return result;
    }

    public boolean isOpenEnded() {
        return this.openEnded;
    }

    public int getYear() {
        return this.year;
    }

    public Month getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public boolean isWeekDayOffsetPositive() {
        return this.weekDayOffsetPositive;
    }

    public WeekDay getWeekDayOffset() {
        return this.weekDayOffset;
    }

    public int getDayOffset() {
        return this.dayOffset;
    }

    public VarDate getVarDate() {
        return this.varDate;
    }

    public void setVarDate(VarDate varDate) {
        this.varDate = varDate;
    }

    public void setVarDate(@NotNull String date) {
        this.varDate = VarDate.getValue(date);
    }

    public void setOpenEnded(boolean openEnded) {
        this.openEnded = openEnded;
    }

    public void setYear(int year) {
        if (year != Integer.MIN_VALUE && year < 1900) {
            throw new IllegalArgumentException(I18n.tr("earlier_than", Integer.toString(year), Integer.toString(1900)));
        }
        this.year = year;
    }

    public void setMonth(Month month) {
        this.month = month;
    }

    public void setMonth(String month) {
        if (month == null || "".equals(month)) {
            this.month = null;
            return;
        }
        this.month = Month.getValue(month);
    }

    public void setDay(int day) {
        if (day != Integer.MIN_VALUE && (day < 1 || day > 31)) {
            throw new IllegalArgumentException(I18n.tr("invalid_month_day", day));
        }
        this.day = day;
    }

    public void setNth(String day, int nth) {
        this.setNth(WeekDay.getValue(day), nth);
    }

    public void setNth(WeekDay day, int nth) {
        if (nth < -5 || nth > 5) {
            throw new IllegalArgumentException(I18n.tr("invalid_occurrence", nth));
        }
        this.nthWeekDay = day;
        this.nth = nth;
    }

    public WeekDay getNthWeekDay() {
        return this.nthWeekDay;
    }

    public int getNth() {
        return this.nth;
    }

    public void setWeekDayOffsetPositive(boolean weekDayOffsetPositive) {
        this.weekDayOffsetPositive = weekDayOffsetPositive;
    }

    public void setWeekDayOffset(WeekDay weekDayOffset) {
        this.weekDayOffset = weekDayOffset;
    }

    public void setWeekDayOffset(String weekDayOffset) {
        this.weekDayOffset = WeekDay.getValue(weekDayOffset);
    }

    public void setDayOffset(int dayOffset) {
        this.dayOffset = dayOffset;
    }

    boolean isUndefined() {
        return this.year == Integer.MIN_VALUE && this.month == null && this.day == Integer.MIN_VALUE && this.varDate == null;
    }

    @Override
    public DateWithOffset copy() {
        return new DateWithOffset(this);
    }
}

