/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.MDC;

public class LBHttp2SolrClient
extends LBSolrClient {
    private final Http2SolrClient solrClient;

    @Deprecated
    public LBHttp2SolrClient(Http2SolrClient solrClient, String ... baseSolrUrls) {
        super(Arrays.asList(baseSolrUrls));
        this.solrClient = solrClient;
    }

    private LBHttp2SolrClient(Builder builder) {
        super(Arrays.asList(builder.baseSolrUrls));
        this.solrClient = builder.http2SolrClient;
        this.aliveCheckIntervalMillis = builder.aliveCheckIntervalMillis;
        this.defaultCollection = builder.defaultCollection;
    }

    @Override
    @Deprecated
    protected SolrClient getClient(String baseUrl) {
        return this.solrClient;
    }

    @Override
    protected SolrClient getClient(LBSolrClient.Endpoint endpoint) {
        return this.solrClient;
    }

    @Override
    @Deprecated
    public void setParser(ResponseParser parser) {
        super.setParser(parser);
        this.solrClient.setParser(parser);
    }

    @Override
    public ResponseParser getParser() {
        return this.solrClient.getParser();
    }

    @Override
    @Deprecated
    public void setRequestWriter(RequestWriter writer) {
        super.setRequestWriter(writer);
        this.solrClient.setRequestWriter(writer);
    }

    @Override
    public RequestWriter getRequestWriter() {
        return this.solrClient.getRequestWriter();
    }

    public Set<String> getUrlParamNames() {
        return this.solrClient.getUrlParamNames();
    }

    @Deprecated
    public void setQueryParams(Set<String> queryParams) {
        this.solrClient.setUrlParamNames(queryParams);
    }

    @Deprecated
    public void addQueryParams(String queryOnlyParam) {
        HashSet<String> urlParamNames = new HashSet<String>(this.solrClient.getUrlParamNames());
        urlParamNames.add(queryOnlyParam);
        this.solrClient.setUrlParamNames(urlParamNames);
    }

    @Deprecated
    public Cancellable asyncReq(LBSolrClient.Req req, AsyncListener<LBSolrClient.Rsp> asyncListener) {
        asyncListener.onStart();
        CompletionStage cf = this.requestAsync(req).whenComplete((rsp, t) -> {
            if (t != null) {
                asyncListener.onFailure((Throwable)t);
            } else {
                asyncListener.onSuccess((LBSolrClient.Rsp)rsp);
            }
        });
        return () -> LBHttp2SolrClient.lambda$asyncReq$1((CompletableFuture)cf);
    }

    public CompletableFuture<LBSolrClient.Rsp> requestAsync(final LBSolrClient.Req req) {
        final CompletableFuture<LBSolrClient.Rsp> apiFuture = new CompletableFuture<LBSolrClient.Rsp>();
        final LBSolrClient.Rsp rsp = new LBSolrClient.Rsp();
        final boolean isNonRetryable = req.request instanceof IsUpdateRequest || CommonParams.ADMIN_PATHS.contains(req.request.getPath());
        final LBSolrClient.ServerIterator it = new LBSolrClient.ServerIterator(req, this.zombieServers);
        final AtomicReference<CompletableFuture<NamedList<Object>>> currentFuture = new AtomicReference<CompletableFuture<NamedList<Object>>>();
        RetryListener retryListener = new RetryListener(){

            @Override
            public void onSuccess(LBSolrClient.Rsp rsp2) {
                apiFuture.complete(rsp2);
            }

            @Override
            public void onFailure(Exception e, boolean retryReq) {
                if (retryReq) {
                    String url;
                    try {
                        url = it.nextOrError(e);
                    }
                    catch (Throwable ex) {
                        apiFuture.completeExceptionally(e);
                        return;
                    }
                    MDC.put((String)"LBSolrClient.url", (String)url.toString());
                    if (!apiFuture.isCancelled()) {
                        try {
                            CompletableFuture<NamedList<Object>> future = LBHttp2SolrClient.this.doAsyncRequest(url, req, rsp, isNonRetryable, it.isServingZombieServer(), this);
                            currentFuture.set(future);
                        }
                        catch (Throwable ex) {
                            apiFuture.completeExceptionally(ex);
                        }
                    }
                } else {
                    apiFuture.completeExceptionally(e);
                }
            }
        };
        try {
            CompletableFuture<NamedList<Object>> future = this.doAsyncRequest(it.nextOrError(), req, rsp, isNonRetryable, it.isServingZombieServer(), retryListener);
            currentFuture.set(future);
        }
        catch (SolrServerException e) {
            apiFuture.completeExceptionally(e);
            return apiFuture;
        }
        apiFuture.exceptionally(error -> {
            if (apiFuture.isCancelled()) {
                ((CompletableFuture)currentFuture.get()).cancel(true);
            }
            return null;
        });
        return apiFuture;
    }

    private CompletableFuture<NamedList<Object>> doAsyncRequest(String endpoint, LBSolrClient.Req req, LBSolrClient.Rsp rsp, boolean isNonRetryable, boolean isZombie, RetryListener listener) {
        String baseUrl;
        rsp.server = baseUrl = endpoint.toString();
        Http2SolrClient client = (Http2SolrClient)this.getClient(endpoint);
        try {
            CompletableFuture future = client.requestWithBaseUrl(baseUrl, c -> c.requestAsync(req.getRequest()));
            future.whenComplete((result, throwable) -> {
                if (!future.isCompletedExceptionally()) {
                    this.onSuccessfulRequest((NamedList<Object>)result, endpoint, rsp, isZombie, listener);
                } else if (!future.isCancelled()) {
                    this.onFailedRequest((Throwable)throwable, endpoint, isNonRetryable, isZombie, listener);
                }
            });
            return future;
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    private void onSuccessfulRequest(NamedList<Object> result, String endpoint, LBSolrClient.Rsp rsp, boolean isZombie, RetryListener listener) {
        rsp.rsp = result;
        if (isZombie) {
            this.reviveZombieServer(endpoint);
        }
        listener.onSuccess(rsp);
    }

    private void onFailedRequest(Throwable oe, String endpoint, boolean isNonRetryable, boolean isZombie, RetryListener listener) {
        try {
            throw (Exception)oe;
        }
        catch (BaseHttpSolrClient.RemoteExecutionException e) {
            listener.onFailure(e, false);
        }
        catch (SolrException e) {
            if (!isNonRetryable && RETRY_CODES.contains(e.code())) {
                listener.onFailure(!isZombie ? this.makeServerAZombie(endpoint, e) : e, true);
            } else {
                if (isZombie) {
                    this.reviveZombieServer(endpoint);
                }
                listener.onFailure(e, false);
            }
        }
        catch (SocketException e) {
            if (!isNonRetryable || e instanceof ConnectException) {
                listener.onFailure(!isZombie ? this.makeServerAZombie(endpoint, e) : e, true);
            } else {
                listener.onFailure(e, false);
            }
        }
        catch (SocketTimeoutException e) {
            if (!isNonRetryable) {
                listener.onFailure(!isZombie ? this.makeServerAZombie(endpoint, e) : e, true);
            } else {
                listener.onFailure(e, false);
            }
        }
        catch (SolrServerException e) {
            Throwable rootCause = e.getRootCause();
            if (!isNonRetryable && rootCause instanceof IOException) {
                listener.onFailure(!isZombie ? this.makeServerAZombie(endpoint, e) : e, true);
            } else if (isNonRetryable && rootCause instanceof ConnectException) {
                listener.onFailure(!isZombie ? this.makeServerAZombie(endpoint, e) : e, true);
            } else {
                listener.onFailure(e, false);
            }
        }
        catch (Throwable e) {
            listener.onFailure(new SolrServerException(e), false);
        }
    }

    private static /* synthetic */ void lambda$asyncReq$1(CompletableFuture cf) {
        cf.cancel(true);
    }

    public static class Builder {
        private final Http2SolrClient http2SolrClient;
        private final String[] baseSolrUrls;
        private long aliveCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
        protected String defaultCollection;

        @Deprecated
        public Builder(Http2SolrClient http2Client, String ... baseSolrUrls) {
            this.http2SolrClient = http2Client;
            this.baseSolrUrls = baseSolrUrls;
        }

        public Builder(Http2SolrClient http2Client, LBSolrClient.Endpoint ... endpoints) {
            this.http2SolrClient = http2Client;
            this.baseSolrUrls = new String[endpoints.length];
            for (int i = 0; i < endpoints.length; ++i) {
                this.baseSolrUrls[i] = endpoints[i].getUrl();
            }
        }

        public Builder setAliveCheckInterval(int aliveCheckInterval, TimeUnit unit) {
            if (aliveCheckInterval <= 0) {
                throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + aliveCheckInterval);
            }
            this.aliveCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(aliveCheckInterval, unit);
            return this;
        }

        public Builder withDefaultCollection(String defaultCoreOrCollection) {
            this.defaultCollection = defaultCoreOrCollection;
            return this;
        }

        public LBHttp2SolrClient build() {
            return new LBHttp2SolrClient(this);
        }
    }

    private static interface RetryListener {
        public void onSuccess(LBSolrClient.Rsp var1);

        public void onFailure(Exception var1, boolean var2);
    }
}

