/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Arrays;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class MathFunctions
extends Static {
    public static final double SQRT_2 = 1.4142135623730951;
    public static final double LOG10_2 = 0.3010299956639812;
    public static final int MIN_NAN_ORDINAL = -2097152;
    public static final int MAX_NAN_ORDINAL = 0x1FFFFF;
    static final int POSITIVE_NAN = 2143289344;
    static final int NEGATIVE_NAN = -4194304;
    public static final int HIGHEST_SUPPORTED_PRIME_NUMBER = 65521;
    static final int PRIMES_LENGTH_15_BITS = 3512;
    static final int PRIMES_LENGTH_16_BITS = 6542;
    private static volatile short[] primes = new short[]{2, 3};

    private MathFunctions() {
    }

    public static double average(long l, long l2) {
        long l3 = l ^ l2;
        double d = (l & l2) + (l3 >> 1);
        if ((l3 & 1L) != 0L) {
            d += 0.5;
        }
        return d;
    }

    public static double truncate(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) == 0L ? Math.floor(d) : Math.ceil(d);
    }

    public static double magnitude(double ... dArray) {
        double d;
        double d2;
        double d3;
        int n = dArray.length;
        do {
            if (n != 0) continue;
            return 0.0;
        } while ((d3 = dArray[--n]) == 0.0);
        do {
            if (n != 0) continue;
            return Math.abs(d3);
        } while ((d2 = dArray[--n]) == 0.0);
        do {
            if (n != 0) continue;
            return Math.hypot(d3, d2);
        } while ((d = dArray[--n]) == 0.0);
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        doubleDouble.setToProduct(d3, d3);
        doubleDouble2.setToProduct(d2, d2);
        doubleDouble.add(doubleDouble2);
        doubleDouble2.setToProduct(d, d);
        doubleDouble.add(doubleDouble2);
        while (n != 0) {
            d3 = dArray[--n];
            doubleDouble2.setToProduct(d3, d3);
            doubleDouble.add(doubleDouble2);
        }
        doubleDouble.sqrt();
        return doubleDouble.doubleValue();
    }

    public static int getExponent(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = (int)(l >>> 52 & 0x7FFL);
        if (n == 0) {
            n -= Long.numberOfLeadingZeros(l & 0xFFFFFFFFFFFFFL) - 12;
        }
        return n - 1023;
    }

    public static long pow(long l, int n) {
        long l2 = 1L;
        if (n >= 1) {
            if ((n & 1) != 0) {
                l2 = l;
            }
            while ((n >>>= 1) != 0) {
                l = Math.multiplyExact(l, l);
                if ((n & 1) == 0) continue;
                l2 = Math.multiplyExact(l2, l);
            }
        } else if (n < 0) {
            throw new ArithmeticException(Errors.format((short)92, "exponent", n));
        }
        return l2;
    }

    public static double pow10(int n) {
        return DecimalFunctions.pow10(n);
    }

    public static double pow10(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return DecimalFunctions.pow10(n);
        }
        return Math.pow(10.0, d);
    }

    public static double asinh(double d) {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double atanh(double d) {
        return 0.5 * Math.log1p(2.0 * d / (1.0 - d));
    }

    public static boolean isPositive(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) == 0L && !Double.isNaN(d);
    }

    public static boolean isPositiveZero(double d) {
        return Double.doubleToRawLongBits(d) == 0L;
    }

    public static boolean isNegative(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) != 0L && !Double.isNaN(d);
    }

    public static boolean isNegativeZero(double d) {
        return Double.doubleToRawLongBits(d) == Long.MIN_VALUE;
    }

    public static boolean isSameSign(double d, double d2) {
        return !Double.isNaN(d) && !Double.isNaN(d2) && ((Double.doubleToRawLongBits(d) ^ Double.doubleToRawLongBits(d2)) & Long.MIN_VALUE) == 0L;
    }

    public static double xorSign(double d, double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) ^ Double.doubleToRawLongBits(d2) & Long.MIN_VALUE);
    }

    public static boolean epsilonEqual(float f, float f2, float f3) {
        return Math.abs(f - f2) <= f3 || Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean epsilonEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static float toNanFloat(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("ordinal", -2097152, 0x1FFFFF, n);
        int n2 = n >= 0 ? n : ~n;
        n2 = n2 + 2143289344 | n & Integer.MIN_VALUE;
        assert (Integer.compareUnsigned(n2, n >= 0 ? 2143289344 : -4194304) >= 0) : n;
        float f = Float.intBitsToFloat(n2);
        assert (Float.isNaN(f) && MathFunctions.toNanOrdinal(f) == n) : n;
        return f;
    }

    public static int toNanOrdinal(float f) throws IllegalArgumentException {
        Object[] objectArray;
        short s;
        int n = Float.floatToRawIntBits(f);
        int n2 = (n & Integer.MAX_VALUE) - 2143289344;
        if (n < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        if (n2 >= -2097152 && n2 <= 0x1FFFFF) {
            return n2;
        }
        if (Float.isNaN(f)) {
            s = 46;
            objectArray = Integer.toHexString(n);
        } else {
            s = 45;
            objectArray = new Object[]{"value", Float.valueOf(f)};
        }
        throw new IllegalArgumentException(Errors.format(s, objectArray));
    }

    public static double quadrupleToDouble(long l, long l2) {
        long l3 = l & Long.MIN_VALUE;
        long l4 = (l & 0x7FFF000000000000L) >> 48;
        l &= 0xFFFFFFFFFFFFL;
        if (l4 == 0L) {
            return Double.longBitsToDouble(l3);
        }
        if (l4 == 32767L) {
            if (l == 0L && l2 == 0L) {
                return Double.longBitsToDouble(l3 | 0x7FF0000000000000L);
            }
            return Double.NaN;
        }
        if ((l4 -= 15360L) < 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        if (l4 > 2046L) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble(l3 | l4 << 52 | l << 4 | l2 >>> 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int primeNumberAt(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(6542, n);
        short[] sArray = primes;
        if (n < sArray.length) return Short.toUnsignedInt(sArray[n]);
        Class<MathFunctions> clazz = MathFunctions.class;
        synchronized (MathFunctions.class) {
            sArray = primes;
            if (n < sArray.length) return Short.toUnsignedInt(sArray[n]);
            int n2 = sArray.length;
            int n3 = Short.toUnsignedInt(sArray[n2 - 1]);
            sArray = Arrays.copyOf(sArray, Math.min((n | 0xF) + 1, 6542));
            block3: while (true) {
                int n4;
                int n5 = (int)Math.sqrt(n3 += 2);
                int n6 = 0;
                do {
                    if (n3 % (n4 = Short.toUnsignedInt(sArray[++n6])) == 0) continue block3;
                } while (n4 <= n5);
                sArray[n2] = (short)n3;
                if (++n2 >= sArray.length) break;
            }
            primes = sArray;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Short.toUnsignedInt(sArray[n]);
        }
    }

    public static int nextPrimeNumber(int n) throws IllegalArgumentException {
        int n2;
        ArgumentChecks.ensureBetween("number", 2, 65521, n);
        short[] sArray = primes;
        int n3 = 0;
        int n4 = Math.min(3512, sArray.length);
        if (n > Short.MAX_VALUE) {
            n3 = n4;
            n4 = sArray.length;
        }
        if ((n2 = Arrays.binarySearch(sArray, n3, n4, (short)n)) < 0 && (n2 ^= 0xFFFFFFFF) >= sArray.length) {
            int n5;
            while ((n5 = MathFunctions.primeNumberAt(n2++)) < n) {
            }
            return n5;
        }
        return Short.toUnsignedInt(sArray[n2]);
    }

    public static int[] divisors(int n) {
        int n2;
        int n3;
        if (n == 0) {
            return ArraysExt.EMPTY_INT;
        }
        n = Math.abs(n);
        int[] nArray = new int[16];
        nArray[0] = 1;
        int n4 = 1;
        int n5 = 0;
        while (JDK9.multiplyFull(n3 = MathFunctions.primeNumberAt(n5), n3) <= (long)n) {
            if (n % n3 == 0) {
                if (n4 == nArray.length) {
                    nArray = Arrays.copyOf(nArray, n4 * 2);
                }
                nArray[n4++] = n3;
            }
            ++n5;
        }
        n3 = n4;
        if (n4 * 2 > nArray.length) {
            nArray = Arrays.copyOf(nArray, n4 * 2);
        }
        if ((n5 = nArray[--n3]) != (n2 = n / n5)) {
            nArray[n4++] = n2;
        }
        while (--n3 >= 0) {
            nArray[n4++] = n / nArray[n3];
        }
        for (int i = 1; i < n4; ++i) {
            long l;
            n5 = nArray[i];
            for (int j = i; j < n4 && (l = JDK9.multiplyFull(n5, nArray[j])) <= (long)n; ++j) {
                int n6;
                n2 = (int)l;
                if (n % n2 != 0 || (n6 = Arrays.binarySearch(nArray, j, n4, n2)) >= 0) continue;
                n6 ^= 0xFFFFFFFF;
                if (n4 == nArray.length) {
                    nArray = Arrays.copyOf(nArray, n4 * 2);
                }
                System.arraycopy(nArray, n6, nArray, n6 + 1, n4 - n6);
                nArray[n6] = n2;
                ++n4;
            }
        }
        nArray = ArraysExt.resize(nArray, n4);
        assert (ArraysExt.isSorted(nArray, true));
        return nArray;
    }

    public static int[] commonDivisors(int ... nArray) {
        int n;
        if (nArray.length == 0) {
            return ArraysExt.EMPTY_INT;
        }
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.abs(nArray[i]);
            if (n > n2) continue;
            n2 = n;
        }
        int[] nArray2 = MathFunctions.divisors(n2);
        n = nArray2.length;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = Math.abs(nArray[i]);
            if (n3 == n2) continue;
            int n4 = n;
            while (--n4 > 0) {
                if (n3 % nArray2[n4] == 0) continue;
                System.arraycopy(nArray2, n4 + 1, nArray2, n4, --n - n4);
            }
        }
        return ArraysExt.resize(nArray2, n);
    }

    public static double[] polynomialRoots(double ... dArray) {
        int n = dArray.length;
        block7: while (n > 0) {
            double d;
            double d2;
            if ((d2 = dArray[--n]) == 0.0) continue;
            int n2 = 0;
            while ((d = dArray[n2]) == 0.0) {
                ++n2;
            }
            switch (n - n2) {
                case 0: {
                    break block7;
                }
                case 1: {
                    double d3 = -d / d2;
                    if (Double.isNaN(d3)) break block7;
                    return new double[]{d3};
                }
                case 2: {
                    double[] dArray2;
                    double d4 = dArray[n2 + 1];
                    double d5 = -0.5 * (d4 + Math.copySign(Math.sqrt(d4 * d4 - 4.0 * d2 * d), d4));
                    double d6 = d5 / d2;
                    double d7 = d / d5;
                    if (Double.isNaN(d6) && Double.isNaN(d7)) break block7;
                    if (d6 != d7) {
                        double[] dArray3 = new double[2];
                        dArray3[0] = d6;
                        dArray2 = dArray3;
                        dArray3[1] = d7;
                    } else {
                        double[] dArray4 = new double[1];
                        dArray2 = dArray4;
                        dArray4[0] = d6;
                    }
                    return dArray2;
                }
                case 3: {
                    return MathFunctions.refineRoots(dArray, MathFunctions.solveCubic(dArray[n2 + 2] / d2, dArray[n2 + 1] / d2, d / d2, false));
                }
                case 4: {
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    int n3;
                    double d12 = d / d2;
                    d = dArray[n2 + 1] / d2;
                    double d13 = dArray[n2 + 2] / d2;
                    d2 = dArray[n2 + 3] / d2;
                    double d14 = d2 * d2;
                    double d15 = -0.375 * d14 + d13;
                    double d16 = 0.125 * (d14 * d2) - 0.5 * (d2 * d13) + d;
                    double d17 = -0.01171875 * (d14 * d14) + 0.0625 * (d14 * d13) - 0.25 * (d2 * d) + d12;
                    double[] dArray5 = MathFunctions.solveCubic(-2.0 * d15, d15 * d15 - 4.0 * d17, d16 * d16, true);
                    if (dArray5.length != 4) break block7;
                    for (n3 = 0; n3 < 3; ++n3) {
                        dArray5[n3] = Math.sqrt(-dArray5[n3]);
                    }
                    if (MathFunctions.isPositive(d16)) {
                        for (n3 = 0; n3 < 3; ++n3) {
                            dArray5[n3] = -dArray5[n3];
                        }
                    }
                    if (Double.isNaN(d11 = (d10 = dArray5[0]) + (d9 = dArray5[1]) + (d8 = dArray5[2]))) break block7;
                    dArray5[0] = d11 / 2.0 - (d2 /= 4.0);
                    dArray5[1] = (d10 - d9 - d8) / 2.0 - d2;
                    dArray5[2] = (-d10 + d9 - d8) / 2.0 - d2;
                    dArray5[3] = (-d10 - d9 + d8) / 2.0 - d2;
                    return MathFunctions.refineRoots(dArray, MathFunctions.removeDuplicated(dArray5));
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return ArraysExt.EMPTY_DOUBLE;
    }

    private static double[] solveCubic(double d, double d2, double d3, boolean bl) {
        double d4;
        double d5 = (d * d - 3.0 * d2) / 9.0;
        double d6 = (d * (d * d - 4.5 * d2) + 13.5 * d3) / 27.0;
        double d7 = d5 * d5 * d5;
        double d8 = d6 * d6;
        d /= 3.0;
        if (d8 < d7) {
            d2 = Math.acos(d6 / Math.sqrt(d7)) / 3.0;
            d3 = -2.0 * Math.sqrt(d5);
            double[] dArray = new double[bl ? 4 : 3];
            dArray[2] = d3 * Math.cos(d2 - 2.0943951023931953) - d;
            dArray[1] = d3 * Math.cos(d2 + 2.0943951023931953) - d;
            dArray[0] = d3 * Math.cos(d2) - d;
            if (!bl) {
                dArray = MathFunctions.removeDuplicated(dArray);
            }
            return dArray;
        }
        if (!bl && !Double.isNaN(d4 = ((d2 = -Math.copySign(Math.cbrt(Math.abs(d6) + Math.sqrt(d8 - d7)), d6)) == 0.0 ? 0.0 : d2 + d5 / d2) - d)) {
            return new double[]{d4};
        }
        return ArraysExt.EMPTY_DOUBLE;
    }

    private static double[] removeDuplicated(double[] dArray) {
        int n = 1;
        block0: while (n < dArray.length) {
            int n2 = n;
            while (--n2 >= 0) {
                if (dArray[n2] != dArray[n]) continue;
                dArray = ArraysExt.remove(dArray, n, 1);
                continue block0;
            }
            ++n;
        }
        return dArray;
    }

    private static double[] refineRoots(double[] dArray, double[] dArray2) {
        block0: for (int i = 0; i < dArray2.length; ++i) {
            double d;
            double d2;
            double d3;
            double d4 = Double.POSITIVE_INFINITY;
            double d5 = dArray2[i];
            do {
                double d6 = 1.0;
                d = 0.0;
                d2 = dArray[0];
                double d7 = 0.0;
                double d8 = 0.0;
                for (int j = 1; j < dArray.length; ++j) {
                    double d9 = dArray[j];
                    double d10 = d9 * (d6 * (double)i) + d8;
                    d8 = d10 + (d - (d += d10));
                    d10 = d9 * (d6 *= d5) + d7;
                    d7 = d10 + (d2 - (d2 += d10));
                }
                if (!(d4 > (d4 = Math.abs(d2)))) continue block0;
                dArray2[i] = d5;
            } while (d5 != (d5 -= (d3 = d2 / d)) && Double.isFinite(d5));
        }
        return dArray2;
    }
}

