/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.Rescorer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.AbstractReRankQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.ReRankOperator;
import org.apache.solr.search.ReRankScaler;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReRankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rerank";
    private static Query defaultQuery = new MatchAllDocsQuery();
    public static final String RERANK_QUERY = "reRankQuery";
    public static final String RERANK_DOCS = "reRankDocs";
    public static final int RERANK_DOCS_DEFAULT = 200;
    public static final String RERANK_WEIGHT = "reRankWeight";
    public static final double RERANK_WEIGHT_DEFAULT = 2.0;
    public static final String RERANK_OPERATOR = "reRankOperator";
    public static final String RERANK_OPERATOR_DEFAULT = "add";
    public static final String RERANK_SCALE = "reRankScale";
    public static final String RERANK_MAIN_SCALE = "reRankMainScale";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ReRankQParser(query, localParams, params, req);
    }

    private static final class ReRankQuery
    extends AbstractReRankQuery {
        private final Query reRankQuery;
        private final double reRankWeight;
        private final boolean explainResults;

        public int hashCode() {
            return 31 * this.classHash() + this.mainQuery.hashCode() + this.reRankQuery.hashCode() + (int)this.reRankWeight + this.reRankDocs + this.reRankOperator.hashCode() + this.reRankScaler.hashCode();
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ReRankQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ReRankQuery rrq) {
            return this.mainQuery.equals((Object)rrq.mainQuery) && this.reRankQuery.equals((Object)rrq.reRankQuery) && this.reRankWeight == rrq.reRankWeight && this.reRankDocs == rrq.reRankDocs && this.reRankOperator.equals((Object)rrq.reRankOperator) && this.reRankScaler.equals(rrq.reRankScaler);
        }

        public ReRankQuery(Query reRankQuery, int reRankDocs, double reRankWeight, ReRankOperator reRankOperator, ReRankScaler reRankScaler, boolean explainResults) {
            super(defaultQuery, reRankDocs, (Rescorer)new ReRankQueryRescorer(reRankQuery, reRankWeight, reRankOperator), reRankScaler, reRankOperator);
            this.reRankQuery = reRankQuery;
            this.reRankWeight = reRankWeight;
            this.explainResults = explainResults;
        }

        @Override
        public String toString(String s) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("{!").append(ReRankQParserPlugin.NAME);
            sb.append(" mainQuery='").append(this.mainQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_QUERY).append("='").append(this.reRankQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_DOCS).append('=').append(this.reRankDocs).append(' ');
            if (this.reRankScaler.scaleScores()) {
                sb.append(ReRankQParserPlugin.RERANK_WEIGHT).append('=').append(this.reRankScaler.getReRankScaleWeight()).append(' ');
            } else {
                sb.append(ReRankQParserPlugin.RERANK_WEIGHT).append('=').append(this.reRankWeight).append(' ');
            }
            if (this.reRankScaler.getReRankScalerExplain().getReRankScale() != null) {
                sb.append(ReRankQParserPlugin.RERANK_SCALE).append('=').append(this.reRankScaler.getReRankScalerExplain().getReRankScale()).append(' ');
            }
            if (this.reRankScaler.getReRankScalerExplain().getMainScale() != null) {
                sb.append(ReRankQParserPlugin.RERANK_MAIN_SCALE).append('=').append(this.reRankScaler.getReRankScalerExplain().getMainScale()).append(' ');
            }
            sb.append(ReRankQParserPlugin.RERANK_OPERATOR).append('=').append(this.reRankOperator.toLower()).append('}');
            return sb.toString();
        }

        @Override
        protected Query rewrite(Query rewrittenMainQuery) throws IOException {
            return new ReRankQuery(this.reRankQuery, this.reRankDocs, this.reRankWeight, this.reRankOperator, this.reRankScaler, this.explainResults).wrap(rewrittenMainQuery);
        }

        @Override
        public boolean getCache() {
            if (this.reRankScaler.scaleScores() && this.explainResults) {
                return false;
            }
            return super.getCache();
        }
    }

    private static final class ReRankQueryRescorer
    extends QueryRescorer {
        final BiFloatFunction scoreCombiner;

        public ReRankQueryRescorer(Query reRankQuery, double reRankWeight, ReRankOperator reRankOperator) {
            super(reRankQuery);
            switch (reRankOperator) {
                case ADD: {
                    this.scoreCombiner = (score, second) -> (float)((double)score + reRankWeight * (double)second);
                    break;
                }
                case MULTIPLY: {
                    this.scoreCombiner = (score, second) -> (float)((double)score * reRankWeight * (double)second);
                    break;
                }
                case REPLACE: {
                    this.scoreCombiner = (score, second) -> (float)(reRankWeight * (double)second);
                    break;
                }
                default: {
                    this.scoreCombiner = null;
                    throw new IllegalArgumentException("Unexpected: reRankOperator=" + String.valueOf((Object)reRankOperator));
                }
            }
        }

        protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
            if (secondPassMatches) {
                return this.scoreCombiner.func(firstPassScore, secondPassScore);
            }
            return firstPassScore;
        }

        @FunctionalInterface
        static interface BiFloatFunction {
            public float func(float var1, float var2);
        }
    }

    private static class ReRankQParser
    extends QParser {
        private boolean isExplainResults() {
            String[] debugParams;
            ResponseBuilder rb;
            SolrRequestInfo ri = SolrRequestInfo.getRequestInfo();
            if (null != ri && null != (rb = ri.getResponseBuilder())) {
                return rb.isDebugResults();
            }
            boolean debugQuery = this.params.getBool("debugQuery", false);
            if (!debugQuery && (debugParams = this.params.getParams("debug")) != null) {
                for (String debugParam : debugParams) {
                    if (!"true".equals(debugParam)) continue;
                    debugQuery = true;
                    break;
                }
            }
            return debugQuery;
        }

        public ReRankQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(query, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            boolean explainResults;
            double reRankScaleWeight;
            String reRankScale;
            String reRankQueryString = this.localParams.get(ReRankQParserPlugin.RERANK_QUERY);
            if (StrUtils.isBlank((String)reRankQueryString)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "reRankQuery parameter is mandatory");
            }
            QParser reRankParser = QParser.getParser(reRankQueryString, this.req);
            Query reRankQuery = reRankParser.parse();
            int reRankDocs = this.localParams.getInt(ReRankQParserPlugin.RERANK_DOCS, 200);
            reRankDocs = Math.max(1, reRankDocs);
            double reRankWeight = this.localParams.getDouble(ReRankQParserPlugin.RERANK_WEIGHT, 2.0);
            ReRankOperator reRankOperator = ReRankOperator.get(this.localParams.get(ReRankQParserPlugin.RERANK_OPERATOR, ReRankQParserPlugin.RERANK_OPERATOR_DEFAULT));
            String mainScale = this.localParams.get(ReRankQParserPlugin.RERANK_MAIN_SCALE);
            ReRankScaler reRankScaler = new ReRankScaler(mainScale, reRankScale = this.localParams.get(ReRankQParserPlugin.RERANK_SCALE), reRankScaleWeight = reRankWeight, reRankOperator, new ReRankQueryRescorer(reRankQuery, 1.0, ReRankOperator.REPLACE), explainResults = this.isExplainResults());
            if (reRankScaler.scaleScores()) {
                reRankWeight = 1.0;
            }
            return new ReRankQuery(reRankQuery, reRankDocs, reRankWeight, reRankOperator, reRankScaler, explainResults);
        }
    }
}

