/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.solr.client.api.endpoint.ConfigsetsApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.FileTypeMagicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadConfigSet
extends ConfigSetAPIBase
implements ConfigsetsApi.Upload {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public UploadConfigSet(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public SolrJerseyResponse uploadConfigSet(String configSetName, Boolean overwrite, Boolean cleanup, InputStream requestBody) throws IOException {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.ensureConfigSetUploadEnabled();
        boolean overwritesExisting = this.configSetService.checkConfigExists(configSetName);
        boolean requestIsTrusted = UploadConfigSet.isTrusted(this.solrQueryRequest.getUserPrincipal(), this.coreContainer.getAuthenticationPlugin());
        if (overwrite == null) {
            overwrite = true;
        }
        if (cleanup == null) {
            cleanup = false;
        }
        if (overwritesExisting && !overwrite.booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration " + configSetName + " already exists");
        }
        List<Object> filesToDelete = overwritesExisting && cleanup != false ? this.configSetService.getAllConfigFiles(configSetName) : Collections.emptyList();
        this.createBaseNode(this.configSetService, overwritesExisting, requestIsTrusted, configSetName);
        try (ZipInputStream zis = new ZipInputStream(requestBody, StandardCharsets.UTF_8);){
            ZipEntry zipEntry;
            boolean hasEntry = false;
            while ((zipEntry = zis.getNextEntry()) != null) {
                hasEntry = true;
                String filePath = zipEntry.getName();
                filesToDelete.remove(filePath);
                if (zipEntry.isDirectory()) continue;
                this.configSetService.uploadFileToConfig(configSetName, filePath, zis.readAllBytes(), true);
            }
            if (!hasEntry) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either empty zipped data, or non-zipped data was uploaded. In order to upload a configSet, you must zip a non-empty directory to upload.");
            }
        }
        this.deleteUnusedFiles(this.configSetService, configSetName, filesToDelete);
        if (cleanup.booleanValue() && requestIsTrusted && overwritesExisting && !this.configSetService.isConfigSetTrusted(configSetName)) {
            this.configSetService.setConfigSetTrust(configSetName, true);
        }
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public SolrJerseyResponse uploadConfigSetFile(String configSetName, String filePath, Boolean overwrite, Boolean cleanup, InputStream requestBody) throws IOException {
        String fixedSingleFilePath;
        String singleFilePath;
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.ensureConfigSetUploadEnabled();
        boolean overwritesExisting = this.configSetService.checkConfigExists(configSetName);
        boolean requestIsTrusted = UploadConfigSet.isTrusted(this.solrQueryRequest.getUserPrincipal(), this.coreContainer.getAuthenticationPlugin());
        String string = singleFilePath = filePath != null ? filePath : "";
        if (overwrite == null) {
            overwrite = true;
        }
        if (cleanup == null) {
            cleanup = false;
        }
        if ((fixedSingleFilePath = singleFilePath).charAt(0) == '/') {
            fixedSingleFilePath = fixedSingleFilePath.substring(1);
        }
        byte[] data = requestBody.readAllBytes();
        if (fixedSingleFilePath.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The file path provided for upload, '" + singleFilePath + "', is not valid.");
        }
        if (ZkMaintenanceUtils.isFileForbiddenInConfigSets((String)fixedSingleFilePath) || FileTypeMagicUtil.isFileForbiddenInConfigset(data)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The file type provided for upload, '" + singleFilePath + "', is forbidden for use in configSets.");
        }
        if (cleanup.booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet uploads do not allow cleanup=true when file path is used.");
        }
        this.createBaseNode(this.configSetService, overwritesExisting, requestIsTrusted, configSetName);
        this.configSetService.uploadFileToConfig(configSetName, fixedSingleFilePath, data, overwrite);
        return response;
    }

    private void deleteUnusedFiles(ConfigSetService configSetService, String configName, List<String> filesToDelete) throws IOException {
        if (!filesToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("Cleaning up {} unused files", (Object)filesToDelete.size());
            }
            if (log.isDebugEnabled()) {
                log.debug("Cleaning up unused files: {}", filesToDelete);
            }
            configSetService.deleteFilesFromConfig(configName, filesToDelete);
        }
    }
}

