/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hdfs.update;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.hdfs.HdfsDirectoryFactory;
import org.apache.solr.hdfs.store.HdfsDirectory;
import org.apache.solr.hdfs.update.HdfsTransactionLog;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUpdateLog
extends UpdateLog {
    private FileSystem fs;
    private volatile Path hdfsTlogDir;
    private final String confDir;
    private Integer tlogDfsReplication;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();
    public static AtomicLong INIT_FAILED_LOGS_COUNT = new AtomicLong();

    public HdfsUpdateLog() {
        this(null);
    }

    public HdfsUpdateLog(String confDir) {
        this.confDir = confDir;
    }

    public void init(PluginInfo info) {
        super.init(info);
        this.tlogDfsReplication = (Integer)info.initArgs.get("tlogDfsReplication");
        if (this.tlogDfsReplication == null) {
            this.tlogDfsReplication = 3;
        }
        log.info("Initializing HdfsUpdateLog: tlogDfsReplication={}", (Object)this.tlogDfsReplication);
    }

    protected void initTlogDir(SolrCore core) {
        assert (this.fs == null);
        URI ulog = new Path(this.dataDir).toUri();
        URI coreData = new Path(core.getDataDir()).toUri();
        if (!(ulog.getScheme().equals(coreData.getScheme()) && Objects.equals(ulog.getAuthority(), coreData.getAuthority()) && java.nio.file.Path.of(ulog.getPath(), new String[0]).startsWith(coreData.getPath()))) {
            String scopePath = HdfsDirectoryFactory.scopePath(core.getCoreDescriptor());
            this.hdfsTlogDir = new Path(this.dataDir, scopePath);
        } else {
            this.hdfsTlogDir = new Path(this.dataDir, TLOG_NAME);
        }
        this.maybeClearLog(core);
        try {
            DirectoryFactory df = core.getDirectoryFactory();
            Directory tlogDir = df.get(this.hdfsTlogDir.toUri().toString(), DirectoryFactory.DirContext.DEFAULT, "none");
            try {
                this.fs = ((HdfsDirectory)FilterDirectory.unwrap((Directory)tlogDir)).getFileSystem();
            }
            catch (Throwable t) {
                df.release(tlogDir);
                throw t;
            }
            this.releaseTlogDir = () -> df.release(tlogDir);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        while (true) {
            try {
                if (!this.fs.exists(this.hdfsTlogDir)) {
                    boolean success = this.fs.mkdirs(this.hdfsTlogDir);
                    if (success) break;
                    throw new RuntimeException("Could not create directory:" + String.valueOf(this.hdfsTlogDir));
                }
                this.fs.mkdirs(this.hdfsTlogDir);
            }
            catch (RemoteException e) {
                if (e.getClassName().equals("org.apache.hadoop.hdfs.server.namenode.SafeModeException")) {
                    log.warn("The NameNode is in SafeMode - Solr will wait 5 seconds and try again.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.interrupted();
                    }
                    continue;
                }
                throw new RuntimeException("Problem creating directory: " + String.valueOf(this.hdfsTlogDir), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem creating directory: " + String.valueOf(this.hdfsTlogDir), e);
            }
            break;
        }
        String[] oldBufferTlog = HdfsUpdateLog.getBufferLogList(this.fs, this.hdfsTlogDir);
        if (oldBufferTlog != null && oldBufferTlog.length != 0) {
            this.existOldBufferLog = true;
        }
        this.tlogFiles = HdfsUpdateLog.getLogList(this.fs, this.hdfsTlogDir);
        this.id = this.getLastLogId() + 1L;
        if (this.debug) {
            log.debug("UpdateHandler init: tlogDir={}, existing tlogs={}, next id={}", new Object[]{this.hdfsTlogDir, Arrays.asList(this.tlogFiles), this.id});
        }
        HdfsTransactionLog oldLog = null;
        for (String oldLogName : this.tlogFiles) {
            Path f = new Path(this.hdfsTlogDir, oldLogName);
            try {
                oldLog = new HdfsTransactionLog(this.fs, f, null, true, this.tlogDfsReplication);
                this.addOldLog(oldLog, false);
            }
            catch (Exception e) {
                INIT_FAILED_LOGS_COUNT.incrementAndGet();
                log.error("Failure to open existing log file (non fatal) {}", (Object)f, (Object)e);
                try {
                    this.fs.delete(f, false);
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        for (TransactionLog ll : this.logs) {
            if (this.newestLogsOnStartup.size() < 2) {
                this.newestLogsOnStartup.addFirst(ll);
                continue;
            }
            log.info("Closing output for old non-recovery log {}", (Object)ll);
            ll.closeOutput();
        }
    }

    protected String resolveDataDir(SolrCore core, String path) {
        DirectoryFactory df = core.getDirectoryFactory();
        if (!(df instanceof HdfsDirectoryFactory)) {
            throw new IllegalStateException(HdfsUpdateLog.class.getName() + " incompatible with " + df.getClass().getName());
        }
        if (df.isAbsolute(path)) {
            return path;
        }
        try {
            String dataHome = df.getDataHome(core.getCoreDescriptor());
            return new Path(dataHome, path).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getTlogDir() {
        return this.hdfsTlogDir.toUri().toString();
    }

    public static String[] getBufferLogList(FileSystem fs, Path tlogDir) {
        FileStatus[] fileStatuses;
        String prefix = BUFFER_TLOG_NAME + ".";
        assert (fs != null);
        try {
            fileStatuses = fs.listStatus(tlogDir, path -> path.getName().startsWith(prefix));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed on listing old buffer tlog", (Throwable)e);
        }
        String[] names = new String[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            names[i] = fileStatuses[i].getPath().getName();
        }
        return names;
    }

    public static String[] getLogList(FileSystem fs, Path tlogDir) {
        FileStatus[] fileStatuses;
        final String prefix = TLOG_NAME + ".";
        assert (fs != null);
        try {
            fileStatuses = fs.listStatus(tlogDir, new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith(prefix);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object[] names = new String[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            names[i] = fileStatuses[i].getPath().getName();
        }
        Arrays.sort(names);
        return names;
    }

    public void close(boolean committed) {
        this.close(committed, false);
    }

    protected void ensureBufferTlog() {
        if (this.bufferTlog != null) {
            return;
        }
        String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, BUFFER_TLOG_NAME, System.nanoTime());
        this.bufferTlog = new HdfsTransactionLog(this.fs, new Path(this.hdfsTlogDir, newLogName), this.globalStrings, this.tlogDfsReplication);
        this.bufferTlog.isBuffer = true;
    }

    protected void deleteBufferLogs() {
        String[] oldBufferTlog = HdfsUpdateLog.getBufferLogList(this.fs, this.hdfsTlogDir);
        if (oldBufferTlog != null && oldBufferTlog.length != 0) {
            for (String oldBufferLogName : oldBufferTlog) {
                Path f = new Path(this.hdfsTlogDir, oldBufferLogName);
                try {
                    boolean s = this.fs.delete(f, false);
                    if (s) continue;
                    log.error("Could not remove old buffer tlog file:{}", (Object)f);
                }
                catch (IOException e) {
                    log.error("Could not remove old buffer tlog file:{}", (Object)f, (Object)e);
                }
            }
        }
    }

    protected void ensureLog() {
        if (this.tlog == null) {
            String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, TLOG_NAME, this.id);
            HdfsTransactionLog ntlog = new HdfsTransactionLog(this.fs, new Path(this.hdfsTlogDir, newLogName), this.globalStrings, this.tlogDfsReplication);
            this.tlog = ntlog;
        }
    }

    public void clearLog() {
        Path tlogDir = this.hdfsTlogDir;
        try {
            if (this.fs != null && this.fs.exists(tlogDir)) {
                String[] files;
                for (String file : files = this.getLogList(tlogDir)) {
                    Path f = new Path(tlogDir, file);
                    boolean s = this.fs.delete(f, false);
                    if (s) continue;
                    log.error("Could not remove tlog file:{}", (Object)f);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void preSoftCommit(CommitUpdateCommand cmd) {
        this.debug = log.isDebugEnabled();
        super.preSoftCommit(cmd);
    }

    public String[] getLogList(Path tlogDir) throws FileNotFoundException, IOException {
        final String prefix = TLOG_NAME + ".";
        FileStatus[] files = this.fs.listStatus(tlogDir, new PathFilter(){

            public boolean accept(Path name) {
                return name.getName().startsWith(prefix);
            }
        });
        ArrayList<String> fileList = new ArrayList<String>(files.length);
        for (FileStatus file : files) {
            fileList.add(file.getPath().getName());
        }
        return fileList.toArray(new String[0]);
    }

    public String toString() {
        return "HDFSUpdateLog{state=" + String.valueOf(this.getState()) + ", tlog=" + String.valueOf(this.tlog) + "}";
    }
}

